/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge.eventhandlers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.PlayerLinkstore;

public class PlayerLinkstoreEventHandler {
    private static final String TAG_PLAYER_LINKSTORE = "hexal:player_linkstore";
    private static final Map<UUID, PlayerLinkstore> linkstores = new HashMap<UUID, PlayerLinkstore>();
    private static final Map<UUID, PlayerLinkstore.RenderCentre> renderCentres = new HashMap<UUID, PlayerLinkstore.RenderCentre>();

    @Nullable
    public static PlayerLinkstore.RenderCentre getRenderCentre(Player player) {
        return PlayerLinkstoreEventHandler.getRenderCentre(player.m_20148_());
    }

    @Nullable
    public static PlayerLinkstore.RenderCentre getRenderCentre(UUID player) {
        return renderCentres.get(player);
    }

    public static PlayerLinkstore getLinkstore(ServerPlayer player) {
        PlayerLinkstore linkstore = linkstores.get(player.m_20148_());
        if (linkstore == null) {
            linkstore = PlayerLinkstoreEventHandler.loadLinkstore(player);
            linkstores.put(player.m_20148_(), linkstore);
        }
        return linkstore;
    }

    private static PlayerLinkstore loadLinkstore(ServerPlayer player) {
        PlayerLinkstore linkstore = new PlayerLinkstore(player);
        linkstore.loadAdditionalData(player.getPersistentData().m_128469_(TAG_PLAYER_LINKSTORE));
        return linkstore;
    }

    public static ILinkable getTransmittingTo(ServerPlayer player) {
        return PlayerLinkstoreEventHandler.getLinkstore(player).getTransmittingTo();
    }

    public static void setTransmittingTo(ServerPlayer player, int to) {
        PlayerLinkstoreEventHandler.getLinkstore(player).setTransmittingTo(to);
    }

    public static void resetTransmittingTo(ServerPlayer player) {
        PlayerLinkstoreEventHandler.getLinkstore(player).resetTransmittingTo();
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        linkstores.put(player.m_20148_(), PlayerLinkstoreEventHandler.loadLinkstore(player));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        renderCentres.computeIfAbsent(event.getPlayer().m_20148_(), k -> new PlayerLinkstore.RenderCentre((Player)event.getPlayer()));
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        CompoundTag tag = new CompoundTag();
        PlayerLinkstoreEventHandler.getLinkstore(player).saveAdditionalData(tag);
        player.getPersistentData().m_128365_(TAG_PLAYER_LINKSTORE, (Tag)tag);
        linkstores.remove(player.m_20148_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        if (event.getPlayer() == null) {
            return;
        }
        renderCentres.remove(event.getPlayer().m_20148_());
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) throws Exception {
        if (event.side == LogicalSide.CLIENT) {
            PlayerLinkstoreEventHandler.clientTick(event.player);
        } else {
            PlayerLinkstoreEventHandler.serverTick((ServerPlayer)event.player);
        }
    }

    private static void serverTick(ServerPlayer player) {
        linkstores.get(player.m_20148_()).checkLinks();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientTick(Player player) throws Exception {
        if (!player.f_19853_.f_46443_) {
            throw new Exception("PlayerLinkstoreEventHander.clientTick can only be called on the client");
        }
        PlayerLinkstore.RenderCentre renderCentre = PlayerLinkstoreEventHandler.getRenderCentre(player);
        if (renderCentre != null) {
            renderCentre.renderLinks();
        }
    }
}

