/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MiscUtil {
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final int WRAP_LENGTH = 45;

    public static void appendMultilineText(List<Component> result, ChatFormatting formatting, String key, Object ... args) {
        for (String s : I18n.m_118938_((String)key, (Object[])args).split(Pattern.quote("${br}"))) {
            result.add((Component)Component.m_237113_((String)s).m_130940_(formatting));
        }
    }

    public static MutableComponent asFormattable(Component component) {
        return component instanceof MutableComponent ? (MutableComponent)component : component.m_6879_();
    }

    public static List<? extends Component> wrapStringAsTextComponent(String text) {
        return MiscUtil.wrapString(text, 45).stream().map(Component::m_237113_).toList();
    }

    public static String commify(int n) {
        return NumberFormat.getNumberInstance().format(n);
    }

    public static List<String> wrapString(String text, int maxCharPerLine) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(text.length());
        String format = "";
        for (String para : text.split(Pattern.quote("${br}"))) {
            StringTokenizer tok = new StringTokenizer(para, " ");
            int lineLen = 0;
            while (tok.hasMoreTokens()) {
                String word = tok.nextToken();
                int idx = word.lastIndexOf("\u00a7");
                if (idx >= 0 && idx < word.length() - 1) {
                    format = word.substring(idx, idx + 2);
                    lineLen -= 2;
                }
                if (lineLen + word.length() > maxCharPerLine) {
                    result.add(builder.toString());
                    builder.delete(0, builder.length());
                    builder.append(format);
                    lineLen = 0;
                } else if (lineLen > 0) {
                    builder.append(" ");
                    ++lineLen;
                }
                builder.append(word);
                lineLen += word.length();
            }
            result.add(builder.toString());
            builder.delete(0, builder.length());
            builder.append(format);
        }
        return result;
    }

    public static String locToString(ResourceLocation dim, BlockPos pos) {
        String s = dim.m_135827_().equals("minecraft") ? dim.m_135815_() : dim.toString();
        return String.format("%s [%d,%d,%d]", s, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static String locToString(GlobalPos pos) {
        return MiscUtil.locToString(pos.m_122640_().m_135782_(), pos.m_122646_());
    }

    public static ResourceLocation RL(String name) {
        return new ResourceLocation("modularrouters", name);
    }

    public static int getYawFromFacing(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> 180;
            case Direction.WEST -> 90;
            case Direction.EAST -> -90;
            default -> 0;
        };
    }

    public static Component settingsStr(String prefix, Component c) {
        return Component.m_237113_((String)prefix).m_7220_(c);
    }

    public static CompoundTag serializeGlobalPos(GlobalPos globalPos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)globalPos.m_122646_()));
        tag.m_128359_("dim", globalPos.m_122640_().m_135782_().toString());
        return tag;
    }

    public static GlobalPos deserializeGlobalPos(CompoundTag tag) {
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dim")));
        return GlobalPos.m_122643_((ResourceKey)worldKey, (BlockPos)NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos")));
    }

    @CheckForNull
    public static ServerLevel getWorldForGlobalPos(GlobalPos pos) {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(pos.m_122640_());
    }

    public static GlobalPos makeGlobalPos(Level w, BlockPos pos) {
        return GlobalPos.m_122643_((ResourceKey)w.m_46472_(), (BlockPos)pos);
    }

    public static boolean blockHasSolidSide(BlockState state, BlockGetter worldIn, BlockPos pos, Direction side) {
        return Block.m_49918_((VoxelShape)state.m_60816_(worldIn, pos), (Direction)side);
    }

    public static Set<TagKey<Item>> itemTags(Item item) {
        return Registry.f_122827_.m_206081_((ResourceKey)Registry.f_122827_.m_7854_((Object)item).orElseThrow()).m_203616_().collect(Collectors.toSet());
    }

    public static Set<TagKey<Fluid>> fluidTags(Fluid fluid) {
        return Registry.f_122822_.m_206081_((ResourceKey)Registry.f_122822_.m_7854_((Object)fluid).orElseThrow()).m_203616_().collect(Collectors.toSet());
    }

    public static Optional<ResourceLocation> getRegistryName(Item item) {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    public static Optional<ResourceLocation> getRegistryName(Block block) {
        return Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((Object)block));
    }
}

