/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.features.P2PTunnelAttunement;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.P2PTunnelFrequencyModelData;
import appeng.me.service.P2PService;
import appeng.parts.BasicStatePart;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public abstract class P2PTunnelPart<T extends P2PTunnelPart<T>>
extends BasicStatePart {
    private static final String CONFIG_NBT_TYPE = "p2pType";
    private static final String CONFIG_NBT_FREQ = "p2pFreq";
    private boolean output;
    private short freq;

    public P2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setIdlePowerUsage(this.getPowerDrainPerTick());
    }

    protected float getPowerDrainPerTick() {
        return 1.0f;
    }

    @Nullable
    public T getInput() {
        if (this.getFrequency() == 0) {
            return null;
        }
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            P2PTunnelPart tunnel = P2PService.get(grid).getInput(this.getFrequency());
            if (this.getClass().isInstance(tunnel)) {
                return (T)tunnel;
            }
        }
        return null;
    }

    public List<T> getOutputs() {
        return this.getOutputStream().toList();
    }

    public Stream<T> getOutputStream() {
        IGrid grid;
        if (this.getMainNode().isActive() && (grid = this.getMainNode().getGrid()) != null) {
            return P2PService.get(grid).getOutputs(this.getFrequency(), this.getClass());
        }
        return Stream.empty();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.setOutput(data.m_128471_("output"));
        this.freq = data.m_128448_("freq");
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128379_("output", this.isOutput());
        data.m_128376_("freq", this.getFrequency());
    }

    @Override
    public boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        short oldf = this.freq;
        this.freq = data.readShort();
        return c || oldf != this.freq;
    }

    @Override
    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeShort((int)this.getFrequency());
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    public boolean useStandardMemoryCard() {
        return false;
    }

    @Override
    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        Item partItem2;
        Item item;
        if (this.isClientSide()) {
            return true;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        ItemStack is = player.m_21120_(hand);
        if (!is.m_41619_() && (item = is.m_41720_()) instanceof IMemoryCard) {
            IMemoryCard mc = (IMemoryCard)item;
            CompoundTag configData = mc.getData(is);
            IPartItem<?> partItem2 = IPartItem.byId(new ResourceLocation(configData.m_128461_(CONFIG_NBT_TYPE)));
            if (partItem2 != null && P2PTunnelPart.class.isAssignableFrom(partItem2.getPartClass())) {
                P2PTunnelPart<Object> newBus = this;
                if (newBus.getPartItem() != partItem2) {
                    newBus = this.getHost().replacePart(partItem2, this.getSide(), player, hand);
                }
                if (newBus instanceof P2PTunnelPart) {
                    P2PTunnelPart newTunnel = newBus;
                    newTunnel.importSettings(SettingsFrom.MEMORY_CARD, configData, player);
                }
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
            return false;
        }
        ItemStack newType = P2PTunnelAttunement.getTunnelPartByTriggerItem(is);
        if (!newType.m_41619_() && newType.m_41720_() != this.getPartItem() && (partItem2 = newType.m_41720_()) instanceof IPartItem) {
            IPartItem partItem3 = (IPartItem)partItem2;
            boolean oldOutput = this.isOutput();
            short myFreq = this.getFrequency();
            Object tunnel = this.getHost().replacePart(partItem3, this.getSide(), player, hand);
            if (tunnel instanceof P2PTunnelPart) {
                P2PTunnelPart newTunnel = (P2PTunnelPart)tunnel;
                newTunnel.setOutput(oldOutput);
                newTunnel.onTunnelNetworkChange();
                newTunnel.getMainNode().ifPresent(grid -> P2PService.get(grid).updateFreq(newTunnel, myFreq));
            }
            Platform.notifyBlocksOfNeighbors(this.getLevel(), this.getBlockEntity().m_58899_());
            return true;
        }
        return false;
    }

    @Override
    public boolean onPartShiftActivate(Player player, InteractionHand hand, Vec3 pos) {
        Item item;
        ItemStack is = player.m_150109_().m_36056_();
        if (!is.m_41619_() && (item = is.m_41720_()) instanceof IMemoryCard) {
            IMemoryCard mc = (IMemoryCard)item;
            if (this.isClientSide()) {
                return true;
            }
            CompoundTag data = mc.getData(is);
            short storedFrequency = data.m_128448_("freq");
            short newFreq = this.getFrequency();
            boolean wasOutput = this.isOutput();
            this.setOutput(false);
            boolean needsNewFrequency = wasOutput || this.getFrequency() == 0 || storedFrequency == newFreq;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                P2PService p2p = P2PService.get(grid);
                if (needsNewFrequency) {
                    newFreq = p2p.newFrequency();
                }
                p2p.updateFreq(this, newFreq);
            }
            this.onTunnelConfigChange();
            String type = this.getPartItem().m_5456_().m_5524_();
            this.exportSettings(SettingsFrom.MEMORY_CARD, data);
            mc.setMemoryCardContents(is, type, data);
            if (needsNewFrequency) {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_RESET);
            } else {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            }
            return true;
        }
        return false;
    }

    @Override
    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        short freq;
        super.importSettings(mode, input, player);
        if (input.m_128425_(CONFIG_NBT_FREQ, 2) && (freq = input.m_128448_(CONFIG_NBT_FREQ)) != this.freq) {
            this.setOutput(true);
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                P2PService.get(grid).updateFreq(this, freq);
            } else {
                this.setFrequency(freq);
                this.onTunnelNetworkChange();
            }
        }
    }

    @Override
    public void exportSettings(SettingsFrom mode, CompoundTag output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.m_128359_(CONFIG_NBT_TYPE, IPartItem.getId(this.getPartItem()).toString());
            if (this.freq != 0) {
                output.m_128376_(CONFIG_NBT_FREQ, this.freq);
                AEColor[] colors = Platform.p2p().toColors(this.freq);
                int[] colorCode = new int[]{colors[0].ordinal(), colors[0].ordinal(), colors[1].ordinal(), colors[1].ordinal(), colors[2].ordinal(), colors[2].ordinal(), colors[3].ordinal(), colors[3].ordinal()};
                output.m_128385_("colorCode", colorCode);
            }
        }
    }

    public void onTunnelConfigChange() {
    }

    public void onTunnelNetworkChange() {
    }

    protected void queueTunnelDrain(PowerUnits unit, double f) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * 0.05);
        this.getMainNode().ifPresent(grid -> grid.getEnergyService().extractAEPower(ae_to_tax, Actionable.MODULATE, PowerMultiplier.ONE));
    }

    public short getFrequency() {
        return this.freq;
    }

    public void setFrequency(short freq) {
        short oldf = this.freq;
        this.freq = freq;
        if (oldf != this.freq) {
            this.getHost().markForSave();
            this.getHost().markForUpdate();
        }
    }

    public boolean isOutput() {
        return this.output;
    }

    void setOutput(boolean output) {
        this.output = output;
        this.getHost().markForSave();
    }

    @Override
    public ModelData getModelData() {
        long ret = Short.toUnsignedLong(this.getFrequency());
        if (this.isActive() && this.isPowered()) {
            ret |= 0x10000L;
        }
        return ModelData.builder().with(P2PTunnelFrequencyModelData.FREQUENCY, (Object)ret).build();
    }
}

