/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.core.AELog;
import appeng.core.worlddata.AESavedData;
import appeng.core.worlddata.IGridStorageSaveData;
import appeng.me.GridStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class GridStorageSaveData
extends AESavedData
implements IGridStorageSaveData {
    public static final String NAME = "ae2_storage";
    private static final String TAG_NEXT_ID = "nextId";
    public static final String TAG_STORAGE = "storage";
    private final Map<Long, GridStorage> storage = new HashMap<Long, GridStorage>();
    private long nextGridId;

    @Override
    public GridStorage getGridStorage(long storageID) {
        GridStorage result = this.storage.get(storageID);
        if (result == null) {
            result = new GridStorage(storageID);
            this.storage.put(storageID, result);
        }
        return result;
    }

    @Override
    public GridStorage getNewGridStorage() {
        return this.getGridStorage(this.nextGridId++);
    }

    @Override
    public void destroyGridStorage(long id) {
        this.storage.remove(id);
    }

    public static GridStorageSaveData load(CompoundTag tag) {
        GridStorageSaveData result = new GridStorageSaveData();
        result.nextGridId = tag.m_128454_(TAG_NEXT_ID);
        CompoundTag storageTag = tag.m_128469_(TAG_STORAGE);
        for (String storageIdStr : storageTag.m_128431_()) {
            long storageId;
            try {
                storageId = Long.parseLong(storageIdStr);
            }
            catch (NumberFormatException e) {
                AELog.warn("Unable to load grid storage with malformed id: '{}'", storageIdStr);
                continue;
            }
            result.storage.put(storageId, new GridStorage(storageId, storageTag.m_128469_(storageIdStr)));
        }
        return result;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128356_(TAG_NEXT_ID, this.nextGridId);
        CompoundTag storageTag = new CompoundTag();
        for (Map.Entry<Long, GridStorage> entry : this.storage.entrySet()) {
            GridStorage gridStorage = entry.getValue();
            if (gridStorage.getGrid() == null || gridStorage.getGrid().isEmpty()) continue;
            try {
                entry.getValue().saveState();
            }
            catch (Exception e) {
                AELog.warn("Failed to save state of Grid {}, storing last known value instead.", entry.getKey(), e);
            }
            storageTag.m_128365_(String.valueOf(entry.getKey()), (Tag)entry.getValue().dataObject());
        }
        tag.m_128365_(TAG_STORAGE, (Tag)storageTag);
        return tag;
    }

    public boolean m_77764_() {
        return true;
    }
}

