/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.filter.AEItemDefinitionFilter;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WirelessBlockEntity
extends AENetworkInvBlockEntity
implements IWirelessAccessPoint,
IPowerChannelState {
    public static final int POWERED_FLAG = 1;
    public static final int CHANNEL_FLAG = 2;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    private int clientFlags = 0;

    public WirelessBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.inv.setFilter(new AEItemDefinitionFilter(AEItems.WIRELESS_BOOSTER));
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.getMainNode().setExposedOnSides(EnumSet.noneOf(Direction.class));
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getForward().m_122424_()));
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.markForUpdate();
        }
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        int old = this.getClientFlags();
        this.setClientFlags(data.readByte());
        return old != this.getClientFlags() || c;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        this.setClientFlags(0);
        this.getMainNode().ifPresent((grid, node) -> {
            if (grid.getEnergyService().isNetworkPowered()) {
                this.setClientFlags(this.getClientFlags() | 1);
            }
            if (node.meetsChannelRequirements()) {
                this.setClientFlags(this.getClientFlags() | 2);
            }
        });
        data.writeByte((int)((byte)this.getClientFlags()));
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalBlockPos getLocation() {
        return new DimensionalBlockPos(this);
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
    }

    @Override
    public void onReady() {
        this.getMainNode().setExposedOnSides(EnumSet.of(this.getForward().m_122424_()));
        this.updatePower();
        super.onReady();
    }

    private void updatePower() {
        this.getMainNode().setIdlePowerUsage(AEConfig.instance().wireless_getPowerDrain(this.getBoosters()));
    }

    private int getBoosters() {
        ItemStack boosters = this.inv.getStackInSlot(0);
        return boosters == null ? 0 : boosters.m_41613_();
    }

    @Override
    public void saveChanges() {
        this.updatePower();
        super.saveChanges();
    }

    @Override
    public double getRange() {
        return AEConfig.instance().wireless_getMaxRange(this.getBoosters());
    }

    @Override
    public boolean isActive() {
        if (this.isClientSide()) {
            return this.isPowered() && 2 == (this.getClientFlags() & 2);
        }
        return this.getMainNode().isOnline();
    }

    @Override
    public IGrid getGrid() {
        return this.getMainNode().getGrid();
    }

    @Override
    public boolean isPowered() {
        return 1 == (this.getClientFlags() & 1);
    }

    public int getClientFlags() {
        return this.clientFlags;
    }

    private void setClientFlags(int clientFlags) {
        this.clientFlags = clientFlags;
    }
}

