/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.voidlink;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import me.duquee.createutilities.blocks.voidtypes.VoidLinkBehaviour;
import me.duquee.createutilities.voidlink.VoidLinkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VoidLinkRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (!(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        VoidLinkBehaviour behaviour = (VoidLinkBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, VoidLinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        MutableComponent freq1 = Lang.translateDirect((String)"logistics.firstFrequency", (Object[])new Object[0]);
        MutableComponent freq2 = Lang.translateDirect((String)"logistics.secondFrequency", (Object[])new Object[0]);
        MutableComponent player = Components.translatable((String)"createutilities.logistics.owner");
        for (int index : VoidLinkHandler.arr012) {
            boolean isEmpty;
            AABB bb = new AABB(Vec3.f_82478_, Vec3.f_82478_).m_82400_(0.25);
            MutableComponent label = index < 2 ? (index == 0 ? freq1 : freq2) : player;
            boolean hit = behaviour.testHit(index, target.m_82450_());
            ValueBoxTransform transform = behaviour.getSlot(index);
            ValueBox box = new ValueBox((Component)label, bb, pos).passive(!hit).withColor(6299416);
            boolean bl = index == 2 ? behaviour.getOwner() == null : (isEmpty = behaviour.getFrequencyStack(index == 0).m_41619_());
            if (!isEmpty) {
                box.wideOutline();
            }
            CreateClient.OUTLINER.showValueBox((Object)Pair.of((Object)index, (Object)pos), box.transform(transform)).highlightFace(result.m_82434_());
            if (!hit) continue;
            ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
            if (index < 2) {
                tip.add(label.m_6881_());
                tip.add(Lang.translateDirect((String)(isEmpty ? "logistics.filter.click_to_set" : "logistics.filter.click_to_replace"), (Object[])new Object[0]));
            } else {
                tip.add(label.m_6881_());
                tip.add(Components.translatable((String)("createutilities" + (isEmpty ? ".logistics.void.click_to_set_owner" : ".logistics.void.click_to_remove_owner"))));
            }
            CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip(tip);
        }
    }

    public static void renderOnTileEntity(SmartBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, SkullModelBase skullModelBase) {
        if (te == null || te.m_58901_()) {
            return;
        }
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        float max = AllConfigs.client().filterItemRenderDistance.getF();
        if (!te.isVirtual() && cameraEntity != null && cameraEntity.m_20182_().m_82557_(VecHelper.getCenterOf((Vec3i)te.m_58899_())) > (double)(max * max)) {
            return;
        }
        VoidLinkBehaviour behaviour = (VoidLinkBehaviour)te.getBehaviour(VoidLinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        for (int index : VoidLinkHandler.arr012) {
            ValueBoxTransform transform = behaviour.getSlot(index);
            if (index < 2) {
                ItemStack stack = behaviour.getFrequencyStack(index == 0);
                ms.m_85836_();
                transform.transform(te.m_58900_(), ms);
                ValueBoxRenderer.renderItemIntoValueBox((ItemStack)stack, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
                ms.m_85849_();
                continue;
            }
            GameProfile owner = behaviour.getOwner();
            if (owner == null) continue;
            ms.m_85836_();
            transform.transform(te.m_58900_(), ms);
            float scale = 1.01f;
            ms.m_85841_(scale, scale, scale);
            ms.m_85837_(0.0, -0.25, 0.0);
            VoidLinkRenderer.renderSkull(owner, ms, buffer, light, skullModelBase);
            ms.m_85849_();
        }
    }

    public static void renderSkull(GameProfile owner, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, SkullModelBase model) {
        RenderType renderType = SkullBlockRenderer.m_112523_((SkullBlock.Type)SkullBlock.Types.PLAYER, (GameProfile)owner);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

