/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.mixins;

import com.simibubi.create.content.contraptions.MountedStorage;
import com.simibubi.create.foundation.utility.NBTHelper;
import me.duquee.createutilities.CreateUtilities;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestInventory;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestTileEntity;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorNetworkHandler;
import me.duquee.createutilities.mixins.MountedStorageAccessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MountedStorage.class})
public class MountedStorageMixin {
    @Shadow
    ItemStackHandler handler;
    @Shadow
    boolean valid;
    @Shadow
    boolean noFuel;

    @Inject(method={"addStorageToWorld(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void returnForVoidChest(BlockEntity te, CallbackInfo ci) {
        if (te instanceof VoidChestTileEntity) {
            ci.cancel();
        }
    }

    @Inject(method={"serialize()Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void serializeVoidChest(CallbackInfoReturnable<CompoundTag> cir) {
        ItemStackHandler itemStackHandler = this.handler;
        if (!(itemStackHandler instanceof VoidChestInventory)) {
            return;
        }
        VoidChestInventory voidChest = (VoidChestInventory)itemStackHandler;
        if (!this.valid) {
            cir.setReturnValue(null);
            return;
        }
        CompoundTag tag = this.handler.serializeNBT();
        if (this.noFuel) {
            NBTHelper.putMarker((CompoundTag)tag, (String)"NoFuel");
        }
        NBTHelper.putMarker((CompoundTag)tag, (String)"VoidChest");
        tag.m_128365_("NetworkKey", (Tag)voidChest.getKey().serialize());
        cir.setReturnValue((Object)tag);
    }

    @Inject(method={"deserialize(Lnet/minecraft/nbt/CompoundTag;)Lcom/simibubi/create/content/contraptions/MountedStorage;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void deserializeVoidChest(CompoundTag nbt, CallbackInfoReturnable<MountedStorage> cir) {
        if (nbt == null) {
            return;
        }
        if (!nbt.m_128441_("VoidChest")) {
            return;
        }
        MountedStorageAccessor storage = (MountedStorageAccessor)new MountedStorage(null);
        VoidMotorNetworkHandler.NetworkKey key = VoidMotorNetworkHandler.NetworkKey.deserialize(nbt.m_128469_("NetworkKey"));
        VoidChestInventory voidChest = CreateUtilities.VOID_CHEST_INVENTORIES_DATA.computeStorageIfAbsent(key);
        storage.setHandler(voidChest);
        storage.setValid(true);
        storage.setNoFuel(nbt.m_128441_("NoFuel"));
        cir.setReturnValue((Object)((MountedStorage)storage));
    }

    @Inject(method={"canUseAsStorage(Lnet/minecraft/world/level/block/entity/BlockEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void canUseVoidChestAsStorage(BlockEntity be, CallbackInfoReturnable<Boolean> cir) {
        if (be instanceof VoidChestTileEntity) {
            cir.setReturnValue((Object)true);
        }
    }
}

