/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.tank;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import me.duquee.createutilities.blocks.voidtypes.VoidTileRenderer;
import me.duquee.createutilities.blocks.voidtypes.tank.VoidTankTileEntity;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class VoidTankRenderer
extends SafeBlockEntityRenderer<VoidTankTileEntity>
implements VoidTileRenderer<VoidTankTileEntity> {
    private final SkullModelBase skullModelBase;

    public VoidTankRenderer(BlockEntityRendererProvider.Context context) {
        this.skullModelBase = new SkullModel(context.m_173585_().m_171103_(ModelLayers.f_171163_));
    }

    protected void renderSafe(VoidTankTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderVoid(te, partialTicks, ms, buffer, light, overlay);
        FluidTank tank = te.getFluidStorage();
        if (!te.isClosed()) {
            FluidRenderer.renderFluidBox((FluidStack)tank.getFluid(), (float)0.125f, (float)0.25f, (float)0.125f, (float)0.875f, (float)(0.25f + 0.5f * (float)tank.getFluidAmount() / (float)tank.getCapacity()), (float)0.875f, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false);
        }
    }

    @Override
    public SkullModelBase getSkullModelBase() {
        return this.skullModelBase;
    }

    @Override
    public boolean shouldRenderFrame(VoidTankTileEntity te, Direction direction) {
        return !te.isClosed();
    }

    @Override
    public float getFrameWidth() {
        return 0.75f;
    }

    @Override
    public float getFrameOffset(Direction direction) {
        return direction.m_122434_() == Direction.Axis.Y ? 0.251f : 0.124f;
    }
}

