/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.lgearbox;

import com.simibubi.create.content.contraptions.ITransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import me.duquee.createutilities.blocks.CUTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LShapedGearboxBlock
extends KineticBlock
implements IBE<GearboxBlockEntity>,
ITransformableBlock {
    public static final DirectionProperty FACING_1 = BlockStateProperties.f_61374_;
    public static final DirectionProperty FACING_2 = DirectionProperty.m_61549_((String)"facing_2", (Direction[])new Direction[]{Direction.EAST, Direction.UP, Direction.WEST, Direction.DOWN});

    public LShapedGearboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING_1, (Comparable)Direction.NORTH)).m_61124_((Property)FACING_2, (Comparable)Direction.EAST));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING_1, FACING_2});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        for (Direction facing1 : FACING_1.m_6908_()) {
            if (!this.isNeighborValid(level, pos, facing1)) continue;
            state = (BlockState)state.m_61124_((Property)FACING_1, (Comparable)facing1);
            for (Direction facing2 : FACING_2.m_6908_()) {
                if (!this.isNeighborValid(level, pos, LShapedGearboxBlock.getAbsolute(facing1, facing2))) continue;
                return (BlockState)state.m_61124_((Property)FACING_2, (Comparable)facing2);
            }
            return state;
        }
        Direction facing1 = context.m_8125_();
        Player player = context.m_43723_();
        return (BlockState)state.m_61124_((Property)FACING_1, (Comparable)(player != null && player.m_6144_() ? facing1 : facing1.m_122424_()));
    }

    private boolean isNeighborValid(Level level, BlockPos pos, Direction direction) {
        BlockPos neighborPos = pos.m_121945_(direction);
        BlockState neighborState = level.m_8055_(neighborPos);
        Block block = neighborState.m_60734_();
        if (!(block instanceof IRotate)) {
            return false;
        }
        IRotate neighbor = (IRotate)block;
        return neighbor.hasShaftTowards((LevelReader)level, neighborPos, neighborState, direction.m_122424_());
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return LShapedGearboxBlock.hasShaftTowards(state, face);
    }

    public static boolean hasShaftTowards(BlockState state, Direction face) {
        Direction facing1 = (Direction)state.m_61143_((Property)FACING_1);
        return face == facing1 || face == LShapedGearboxBlock.getAbsolute(facing1, (Direction)state.m_61143_((Property)FACING_2));
    }

    public BlockState getRotatedBlockState(BlockState state, Direction targetedFace) {
        return (BlockState)state.m_61122_((Property)FACING_2);
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        Direction facing1 = (Direction)state.m_61143_((Property)FACING_1);
        Direction facing2 = LShapedGearboxBlock.getAbsolute(facing1, (Direction)state.m_61143_((Property)FACING_2));
        facing1 = LShapedGearboxBlock.rotate(facing1, transform.rotationAxis, transform.rotation);
        facing2 = LShapedGearboxBlock.rotate(facing2, transform.rotationAxis, transform.rotation);
        if (facing1 == Direction.UP || facing1 == Direction.DOWN) {
            Direction placeHolder = facing1;
            facing1 = facing2;
            facing2 = placeHolder;
        }
        facing2 = LShapedGearboxBlock.getRelative(facing1, facing2);
        return (BlockState)((BlockState)state.m_61124_((Property)FACING_1, (Comparable)facing1)).m_61124_((Property)FACING_2, (Comparable)facing2);
    }

    public static Direction rotate(Direction direction, Direction.Axis axis, Rotation rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.CLOCKWISE_90 -> direction.m_175362_(axis);
            case Rotation.COUNTERCLOCKWISE_90 -> direction.m_175364_(axis);
            case Rotation.CLOCKWISE_180 -> {
                if (axis == direction.m_122434_()) {
                    yield direction;
                }
                yield direction.m_122424_();
            }
            case Rotation.NONE -> direction;
        };
    }

    public static Direction getAbsolute(Direction direction1, Direction direction2) {
        return LShapedGearboxBlock.rotate(direction2, Direction.Axis.Y, LShapedGearboxBlock.getRotation(direction1));
    }

    public static Direction getRelative(Direction direction1, Direction direction2) {
        return LShapedGearboxBlock.rotate(direction2, Direction.Axis.Y, LShapedGearboxBlock.getInverse(LShapedGearboxBlock.getRotation(direction1)));
    }

    public static Rotation getRotation(Direction direction1) {
        return switch (direction1) {
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }

    public static Rotation getInverse(Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> Rotation.COUNTERCLOCKWISE_90;
            case Rotation.COUNTERCLOCKWISE_90 -> Rotation.CLOCKWISE_90;
            default -> rotation;
        };
    }

    public Class<GearboxBlockEntity> getBlockEntityClass() {
        return GearboxBlockEntity.class;
    }

    public BlockEntityType<GearboxBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CUTileEntities.LSHAPED_GEARBOX.get();
    }
}

