/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.gearcube;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SimpleKineticRenderer<T extends KineticBlockEntity>
extends KineticBlockEntityRenderer<T> {
    public SimpleKineticRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(T te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        BlockState state = te.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof IRotate)) {
            return;
        }
        IRotate block2 = (IRotate)block;
        BlockPos pos = te.m_58899_();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        for (Direction direction : Iterate.directions) {
            if (!block2.hasShaftTowards((LevelReader)te.m_58904_(), pos, state, direction)) continue;
            Direction.Axis axis = direction.m_122434_();
            SuperByteBuffer shaft = CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)direction);
            float offset = SimpleKineticRenderer.getRotationOffsetForPosition(te, (BlockPos)pos, (Direction.Axis)axis);
            float angle = time * te.getSpeed() * 3.0f / 10.0f % 360.0f;
            if (te.getSpeed() != 0.0f && te.hasSource()) {
                BlockPos source = ((KineticBlockEntity)te).source.m_121996_((Vec3i)pos);
                Direction sourceFacing = Direction.m_122372_((float)source.m_123341_(), (float)source.m_123342_(), (float)source.m_123343_());
                if (sourceFacing.m_122434_() == axis) {
                    angle *= sourceFacing == direction ? 1.0f : -1.0f;
                } else if (sourceFacing.m_122421_() == direction.m_122421_()) {
                    angle *= -1.0f;
                }
            }
            angle += offset;
            angle = angle / 180.0f * (float)Math.PI;
            SimpleKineticRenderer.kineticRotationTransform((SuperByteBuffer)shaft, te, (Direction.Axis)axis, (float)angle, (int)light);
            shaft.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
    }
}

