/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistry;

public class BuildTagsEvent
extends Event {
    public final String directory;
    public final Map<ResourceLocation, List<TagLoader.EntryWithSource>> tags;
    public final ForgeRegistry reg;

    public BuildTagsEvent(ForgeRegistry reg, String directory, Map<ResourceLocation, List<TagLoader.EntryWithSource>> tags) {
        this.reg = reg;
        this.directory = directory;
        this.tags = tags;
    }

    public <T> void addToTag(TagKey<T> key, T value) {
        TagLoader.EntryWithSource te = this.valueToEntry(value);
        if (te != null) {
            this.tags.computeIfAbsent(key.f_203868_(), k -> new ArrayList()).add(te);
        }
    }

    public <T> void addAllToTag(TagKey<T> key, Collection<T> values) {
        ResourceLocation path = key.f_203868_();
        List regTag = this.tags.computeIfAbsent(path, k -> new ArrayList());
        for (T value : values) {
            TagLoader.EntryWithSource te = this.valueToEntry(value);
            if (te == null) continue;
            regTag.add(te);
        }
    }

    public TagLoader.EntryWithSource valueToEntry(Object value) {
        ResourceLocation key = this.reg.getKey(value);
        if (key == null) {
            return null;
        }
        return new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)key), "Default");
    }

    public String toString() {
        return "BuildTagsEvent<" + this.reg.getRegistryKey().m_135782_() + ">{directory=" + this.directory + "}";
    }
}

