/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;
import org.zeith.hammerlib.util.java.Cast;

public class NumberSerializer<N extends Number, NBT extends Tag>
implements INBTSerializer<N> {
    final int nbtType;
    final Function<N, NBT> encode;
    final Function<NBT, N> decode;

    public NumberSerializer(int nbtType, Function<N, NBT> encode, Function<NBT, N> decode) {
        this.nbtType = nbtType;
        this.encode = encode;
        this.decode = decode;
    }

    @Override
    public void serialize(CompoundTag nbt, String key, @NotNull N value) {
        if (value != null) {
            nbt.m_128365_(key, (Tag)this.encode.apply(value));
        }
    }

    @Override
    public N deserialize(CompoundTag nbt, String key) {
        if (nbt.m_128425_(key, this.nbtType)) {
            return (N)((Number)this.decode.apply((Tag)Cast.cast(nbt.m_128423_(key))));
        }
        return null;
    }
}

