/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions.dimensions.level;

import com.google.common.collect.ImmutableMap;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.ArchivedDimension;
import dev.ftb.mods.ftbteams.data.Team;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.util.TriConsumer;

public class DimensionStorage
extends SavedData {
    private static final String SAVE_NAME = "ftbteamdimensions_dimension_store";
    private final HashMap<UUID, ResourceLocation> teamToDimension = new HashMap();
    private final HashMap<ResourceLocation, BlockPos> dimensionSpawnLocations = new HashMap();
    private final List<ArchivedDimension> archivedDimensions = new ArrayList<ArchivedDimension>();
    private final HashMap<UUID, BlockPos> playerNetherPortalLocs = new HashMap();
    private boolean lobbySpawned = false;
    private BlockPos lobbySpawnPos = BlockPos.f_121853_;

    @Nullable
    public static DimensionStorage get() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (level == null) {
            return null;
        }
        DimensionDataStorage dataStorage = level.m_8895_();
        return (DimensionStorage)dataStorage.m_164861_(DimensionStorage::load, DimensionStorage::new, SAVE_NAME);
    }

    public static DimensionStorage get(MinecraftServer server) {
        DimensionDataStorage dataStorage = server.m_129880_(Level.f_46428_).m_8895_();
        return (DimensionStorage)dataStorage.m_164861_(DimensionStorage::load, DimensionStorage::new, SAVE_NAME);
    }

    @Nullable
    public ResourceKey<Level> getDimensionId(Team team) {
        ResourceLocation dimLocation = this.teamToDimension.get(team.getId());
        if (dimLocation == null) {
            return null;
        }
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimLocation);
    }

    public ResourceKey<Level> putDimension(Team playerTeam, String generateDimensionName) {
        return this.putDimension(playerTeam, new ResourceLocation("ftbteamdimensions", "team/%s".formatted(generateDimensionName)));
    }

    public ResourceKey<Level> putDimension(Team playerTeam, ResourceLocation generateDimensionName) {
        this.teamToDimension.put(playerTeam.getId(), generateDimensionName);
        this.m_77762_();
        return this.getDimensionId(playerTeam);
    }

    public void archiveDimension(Team oldTeam) {
        ResourceKey<Level> dimensionId = this.getDimensionId(oldTeam);
        if (dimensionId == null) {
            return;
        }
        this.teamToDimension.remove(oldTeam.getId());
        ServerPlayer player = oldTeam.manager.server.m_6846_().m_11259_(oldTeam.getOwner());
        String playerName = player != null ? player.m_5446_().getString() : "unknown";
        this.archivedDimensions.add(new ArchivedDimension(playerName, oldTeam.getOwner(), oldTeam.getDisplayName(), dimensionId.m_135782_()));
        this.m_77762_();
    }

    public List<ArchivedDimension> getArchivedDimensions() {
        return this.archivedDimensions;
    }

    public Optional<ArchivedDimension> getArchivedDimension(ResourceLocation location) {
        return this.archivedDimensions.stream().filter(e -> e.dimensionName().equals((Object)location)).findFirst();
    }

    public ImmutableMap<UUID, ResourceLocation> getTeamToDimension() {
        return ImmutableMap.copyOf(this.teamToDimension);
    }

    @Nullable
    public BlockPos getDimensionSpawnLocation(ResourceLocation dimKeyLocation) {
        return this.dimensionSpawnLocations.get(dimKeyLocation);
    }

    public void addDimensionSpawn(ResourceLocation location, BlockPos pos) {
        this.dimensionSpawnLocations.put(location, pos);
        this.m_77762_();
    }

    public boolean isLobbySpawned() {
        return this.lobbySpawned;
    }

    public void setLobbySpawned(boolean lobbySpawned) {
        this.lobbySpawned = lobbySpawned;
        this.m_77762_();
    }

    public BlockPos getLobbySpawnPos() {
        return this.lobbySpawnPos;
    }

    public void setLobbySpawnPos(BlockPos lobbySpawnPos) {
        this.lobbySpawnPos = lobbySpawnPos;
        this.m_77762_();
    }

    public void setPlayerNetherPortalLoc(ServerPlayer player, BlockPos blockPosition) {
        if (blockPosition == null) {
            if (this.playerNetherPortalLocs.remove(player.m_20148_()) != null) {
                this.m_77762_();
            }
        } else {
            this.playerNetherPortalLocs.put(player.m_20148_(), blockPosition);
            this.m_77762_();
        }
    }

    public Optional<BlockPos> getPlayerNetherPortalLoc(ServerPlayer player) {
        return Optional.ofNullable(this.playerNetherPortalLocs.get(player.m_20148_()));
    }

    private static DimensionStorage load(CompoundTag compoundTag) {
        DimensionStorage storage = new DimensionStorage();
        storage.read(compoundTag);
        return storage;
    }

    private void read(CompoundTag tag) {
        if (!tag.m_128441_("team_dimensions")) {
            return;
        }
        this.teamToDimension.putAll(this.hashMapReader(UUID::fromString, (tag1, key) -> new ResourceLocation(tag1.m_128461_(key)), tag.m_128469_("team_dimensions")));
        this.dimensionSpawnLocations.putAll(this.hashMapReader(ResourceLocation::new, (tag1, key) -> BlockPos.m_122022_((long)tag1.m_128454_(key)), tag.m_128469_("dimension_spawns")));
        this.playerNetherPortalLocs.putAll(this.hashMapReader(UUID::fromString, (tag1, key) -> BlockPos.m_122022_((long)tag1.m_128454_(key)), tag.m_128469_("player_nether_portal_locs")));
        ListTag dimensionsArchive = tag.m_128437_("dimensions_archive", 10);
        for (int i = 0; i < dimensionsArchive.size(); ++i) {
            this.archivedDimensions.add(ArchivedDimension.read(dimensionsArchive.m_128728_(i)));
        }
        this.lobbySpawned = tag.m_128471_("lobby_spawned");
        if (tag.m_128441_("lobby_spawn_pos")) {
            this.lobbySpawnPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("lobby_spawn_pos"));
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("team_dimensions", (Tag)this.hashMapWriter(this.teamToDimension, (tag, key, value) -> tag.m_128359_(key.toString(), value.toString())));
        nbt.m_128365_("dimension_spawns", (Tag)this.hashMapWriter(this.dimensionSpawnLocations, (tag, key, value) -> tag.m_128356_(key.toString(), value.m_121878_())));
        nbt.m_128365_("player_nether_portal_locs", (Tag)this.hashMapWriter(this.playerNetherPortalLocs, (tag, key, value) -> tag.m_128356_(key.toString(), value.m_121878_())));
        ListTag archivedList = new ListTag();
        this.archivedDimensions.forEach(e -> archivedList.add((Object)e.write()));
        nbt.m_128365_("dimensions_archive", (Tag)archivedList);
        nbt.m_128379_("lobby_spawned", this.lobbySpawned);
        nbt.m_128365_("lobby_spawn_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.lobbySpawnPos));
        this.m_77760_(false);
        return nbt;
    }

    private <K, V> HashMap<K, V> hashMapReader(Function<String, K> keyReader, BiFunction<CompoundTag, String, V> valueReader, CompoundTag tag) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (String key : tag.m_128431_()) {
            hashMap.put(keyReader.apply(key), valueReader.apply(tag, key));
        }
        return hashMap;
    }

    private <K, V> CompoundTag hashMapWriter(HashMap<K, V> map, TriConsumer<CompoundTag, K, V> writer) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<K, V> kvEntry : map.entrySet()) {
            writer.accept((Object)tag, kvEntry.getKey(), kvEntry.getValue());
        }
        return tag;
    }
}

