/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteamdimensions;

import com.mojang.brigadier.CommandDispatcher;
import dev.ftb.mods.ftbteamdimensions.FTBDimensionsConfig;
import dev.ftb.mods.ftbteamdimensions.client.DimensionsClient;
import dev.ftb.mods.ftbteamdimensions.commands.FTBDimensionsCommands;
import dev.ftb.mods.ftbteamdimensions.dimensions.BiomeReplacementUtils;
import dev.ftb.mods.ftbteamdimensions.dimensions.DimensionUtils;
import dev.ftb.mods.ftbteamdimensions.dimensions.DimensionsMain;
import dev.ftb.mods.ftbteamdimensions.dimensions.DimensionsManager;
import dev.ftb.mods.ftbteamdimensions.dimensions.Pregen;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.DimensionStorage;
import dev.ftb.mods.ftbteamdimensions.dimensions.level.DynamicDimensionManager;
import dev.ftb.mods.ftbteamdimensions.dimensions.prebuilt.PrebuiltStructureManager;
import dev.ftb.mods.ftbteamdimensions.net.FTBDimensionsNet;
import dev.ftb.mods.ftbteamdimensions.net.VoidTeamDimension;
import dev.ftb.mods.ftbteamdimensions.registry.ModArgumentTypes;
import dev.ftb.mods.ftbteamdimensions.registry.ModBlocks;
import dev.ftb.mods.ftbteamdimensions.registry.ModWorldGen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ftbteamdimensions")
public class FTBTeamDimensions {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "ftbteamdimensions";

    public FTBTeamDimensions() {
        FTBDimensionsConfig.init();
        IEventBus MOD_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        MOD_BUS.addListener(this::commonSetup);
        MOD_BUS.addListener(this::clientSetup);
        MOD_BUS.addListener(ModWorldGen::setup);
        ModBlocks.BLOCK_REGISTRY.register(MOD_BUS);
        ModBlocks.ITEM_REGISTRY.register(MOD_BUS);
        ModArgumentTypes.ARGUMENT_TYPES.register(MOD_BUS);
        ModWorldGen.STRUCTURE_TYPES.register(MOD_BUS);
        ModWorldGen.STRUCTURE_PIECE_TYPES.register(MOD_BUS);
        ModWorldGen.STRUCTURE_PLACEMENT_TYPES.register(MOD_BUS);
        ModWorldGen.STRUCTURE_PROCESSORS.register(MOD_BUS);
        MinecraftForge.EVENT_BUS.addListener(this::commandsSetup);
        MinecraftForge.EVENT_BUS.addListener(this::reloadListener);
        MinecraftForge.EVENT_BUS.addListener(this::dimensionChanged);
        MinecraftForge.EVENT_BUS.addListener(this::entityJoinLevel);
        MinecraftForge.EVENT_BUS.addListener(this::onLevelLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onChunkLoad);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onSleepFinished);
        FTBDimensionsNet.init();
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DimensionsMain.setup();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> DimensionsClient::init);
    }

    private void commandsSetup(RegisterCommandsEvent event) {
        FTBDimensionsCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void reloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new PrebuiltStructureManager.ReloadListener());
    }

    private void dimensionChanged(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerLevel level = player.m_9236_();
            if (player.m_20092_()) {
                ResourceKey<Level> teamDim = DimensionsManager.INSTANCE.getDimension((Player)player);
                DimensionStorage storage = DimensionStorage.get(level.m_7654_());
                if (event.getDimension().equals((Object)Level.f_46429_)) {
                    BlockPos portalPos = DimensionUtils.isTeamDimension((Level)level) ? player.m_20183_() : null;
                    storage.setPlayerNetherPortalLoc(player, portalPos);
                } else if (level.m_46472_().equals((Object)Level.f_46429_) && event.getDimension().equals((Object)Level.f_46428_) && teamDim != null) {
                    event.setCanceled(true);
                    BlockPos portalPos = storage.getPlayerNetherPortalLoc(player).orElse(null);
                    player.f_8924_.m_201446_(() -> DynamicDimensionManager.teleport(player, teamDim, portalPos));
                    storage.setPlayerNetherPortalLoc(player, null);
                }
            }
        }
    }

    private void entityJoinLevel(EntityJoinLevelEvent event) {
        ServerPlayer sp;
        ServerLevel level;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && DimensionUtils.isVoidChunkGen((level = (sp = (ServerPlayer)entity).m_9236_()).m_7726_().m_8481_())) {
            VoidTeamDimension.INSTANCE.sendTo(sp);
        }
    }

    private void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (!level.f_46443_ && level.m_46472_() == Level.f_46428_ && level.m_7654_() != null) {
                Pregen.maybeDoInitialPregen(level.m_7654_());
            }
        }
    }

    private void onChunkLoad(ChunkEvent.Load event) {
        BlockPos spawnPos;
        ServerLevel level;
        FTBDimensionsConfig.CategoryCommonGeneral general = FTBDimensionsConfig.COMMON_GENERAL;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && DimensionUtils.isTeamDimension((Level)(level = (ServerLevel)levelAccessor)) && (Integer)general.replaceBiomesNearSpawn.get() > 0 && (spawnPos = DimensionStorage.get(level.m_7654_()).getDimensionSpawnLocation(level.m_46472_().m_135782_())) != null) {
            ChunkPos chunkPos = event.getChunk().m_7697_();
            BlockPos pos1 = chunkPos.m_151394_(spawnPos.m_123342_());
            int threshold = (int)Math.pow(((Integer)general.replaceBiomesNearSpawn.get()).intValue(), 2.0);
            if (pos1.m_123331_((Vec3i)spawnPos) < (double)threshold && (!((Boolean)general.replaceColdBiomesOnly.get()).booleanValue() || ((Biome)level.m_204166_(pos1).m_203334_()).m_198904_(pos1))) {
                FTBTeamDimensions.doReplacement(event, level, chunkPos);
            }
        }
    }

    private static void doReplacement(ChunkEvent.Load event, ServerLevel level, ChunkPos chunkPos) {
        ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation((String)FTBDimensionsConfig.COMMON_GENERAL.replaceBiomeId.get()));
        Holder replacement = ((Registry)level.m_5962_().m_6632_(Registry.f_122885_).orElseThrow()).m_206081_(biomeKey);
        BlockPos from = new BlockPos(chunkPos.m_45604_(), level.m_141937_(), chunkPos.m_45605_());
        BlockPos to = new BlockPos(chunkPos.m_45608_(), level.m_151558_(), chunkPos.m_45609_());
        level.m_7654_().m_201446_(() -> BiomeReplacementUtils.replaceBiome(level, event.getChunk(), from, to, (Holder<Biome>)replacement));
    }

    private void onSleepFinished(SleepFinishedTimeEvent event) {
        ServerLevel overworld;
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_46472_().m_135782_().m_135827_().equals(MOD_ID) && (overworld = level.m_7654_().m_129880_(Level.f_46428_)) != null) {
            LevelData levelData;
            overworld.m_8615_(event.getNewTime());
            if (overworld.m_46469_().m_46207_(GameRules.f_46150_) && overworld.m_46471_() && (levelData = overworld.m_6106_()) instanceof ServerLevelData) {
                ServerLevelData data = (ServerLevelData)levelData;
                data.m_6399_(0);
                data.m_5565_(false);
                data.m_6398_(0);
                data.m_5557_(false);
            }
        }
    }
}

