/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.handler;

import com.blakebr0.ironjetpacks.handler.InputHandler;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.network.NetworkHandler;
import com.blakebr0.ironjetpacks.network.message.DecrementThrottleMessage;
import com.blakebr0.ironjetpacks.network.message.IncrementThrottleMessage;
import com.blakebr0.ironjetpacks.network.message.ToggleEngineMessage;
import com.blakebr0.ironjetpacks.network.message.ToggleHoverMessage;
import com.blakebr0.ironjetpacks.network.message.UpdateInputMessage;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class KeybindHandler {
    private static KeyMapping keyEngine;
    private static KeyMapping keyHover;
    private static KeyMapping keyAscend;
    private static KeyMapping keyDescend;
    private static KeyMapping keyIncrementThrottle;
    private static KeyMapping keyDecrementThrottle;
    private static boolean up;
    private static boolean down;
    private static boolean forwards;
    private static boolean backwards;
    private static boolean left;
    private static boolean right;
    private static boolean sprint;

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        keyEngine = new KeyMapping("keybind.ironjetpacks.engine", 86, "Iron Jetpacks");
        keyHover = new KeyMapping("keybind.ironjetpacks.hover", 71, "Iron Jetpacks");
        keyAscend = new KeyMapping("keybind.ironjetpacks.ascend", InputConstants.f_84822_.m_84873_(), "Iron Jetpacks");
        keyDescend = new KeyMapping("keybind.ironjetpacks.descend", InputConstants.f_84822_.m_84873_(), "Iron Jetpacks");
        keyIncrementThrottle = new KeyMapping("keybind.ironjetpacks.increment_throttle", 46, "Iron Jetpacks");
        keyDecrementThrottle = new KeyMapping("keybind.ironjetpacks.decrement_throttle", 44, "Iron Jetpacks");
        event.register(keyEngine);
        event.register(keyHover);
        event.register(keyAscend);
        event.register(keyDescend);
        event.register(keyIncrementThrottle);
        event.register(keyDecrementThrottle);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack chest = JetpackUtils.getEquippedJetpack((Player)player);
        Item item = chest.m_41720_();
        if (item instanceof JetpackItem) {
            KeybindHandler.handleInput((Player)player, chest);
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack chest = JetpackUtils.getEquippedJetpack((Player)player);
        Item item = chest.m_41720_();
        if (item instanceof JetpackItem) {
            KeybindHandler.handleInput((Player)player, chest);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.m_91087_();
            Options settings = mc.f_91066_;
            if (mc.m_91403_() == null) {
                return;
            }
            boolean upNow = keyAscend.m_90862_() ? settings.f_92089_.m_90857_() : keyAscend.m_90857_();
            boolean downNow = keyDescend.m_90862_() ? settings.f_92090_.m_90857_() : keyDescend.m_90857_();
            boolean forwardsNow = settings.f_92085_.m_90857_();
            boolean backwardsNow = settings.f_92087_.m_90857_();
            boolean leftNow = settings.f_92086_.m_90857_();
            boolean rightNow = settings.f_92088_.m_90857_();
            boolean sprintNow = settings.f_92091_.m_90857_();
            if (upNow != up || downNow != down || forwardsNow != forwards || backwardsNow != backwards || leftNow != left || rightNow != right || sprintNow != sprint) {
                up = upNow;
                down = downNow;
                forwards = forwardsNow;
                backwards = backwardsNow;
                left = leftNow;
                right = rightNow;
                sprint = sprintNow;
                KeybindHandler.update(up, down, forwards, backwards, left, right, sprint);
            }
        }
    }

    public static void update(boolean up, boolean down, boolean forwards, boolean backwards, boolean left, boolean right, boolean sprint) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        NetworkHandler.INSTANCE.sendToServer((Object)new UpdateInputMessage(up, down, forwards, backwards, left, right, sprint));
        InputHandler.update((Player)player, up, down, forwards, backwards, left, right, sprint);
    }

    private static void handleInput(Player player, ItemStack stack) {
        MutableComponent throttleText;
        MutableComponent state;
        boolean on;
        if (keyEngine.m_90859_()) {
            on = JetpackUtils.toggleEngine(stack);
            state = on ? ModTooltips.ON.color(ChatFormatting.GREEN).build() : ModTooltips.OFF.color(ChatFormatting.RED).build();
            NetworkHandler.INSTANCE.sendToServer((Object)new ToggleEngineMessage());
            player.m_5661_((Component)ModTooltips.TOGGLE_ENGINE.args(new Object[]{state}).build(), true);
        }
        if (keyHover.m_90859_()) {
            on = JetpackUtils.toggleHover(stack);
            state = on ? ModTooltips.ON.color(ChatFormatting.GREEN).build() : ModTooltips.OFF.color(ChatFormatting.RED).build();
            NetworkHandler.INSTANCE.sendToServer((Object)new ToggleHoverMessage());
            player.m_5661_((Component)ModTooltips.TOGGLE_HOVER.args(new Object[]{state}).build(), true);
        }
        if (keyIncrementThrottle.m_90859_()) {
            double throttle = JetpackUtils.incrementThrottle(stack);
            throttleText = Component.m_237113_((String)((int)(throttle * 100.0) + "%")).m_130940_(ChatFormatting.GREEN);
            NetworkHandler.INSTANCE.sendToServer((Object)new IncrementThrottleMessage());
            player.m_5661_((Component)ModTooltips.CHANGE_THROTTLE.args(new Object[]{throttleText}).build(), true);
        }
        if (keyDecrementThrottle.m_90859_()) {
            double throttle = JetpackUtils.decrementThrottle(stack);
            throttleText = Component.m_237113_((String)((int)(throttle * 100.0) + "%")).m_130940_(ChatFormatting.RED);
            NetworkHandler.INSTANCE.sendToServer((Object)new DecrementThrottleMessage());
            player.m_5661_((Component)ModTooltips.CHANGE_THROTTLE.args(new Object[]{throttleText}).build(), true);
        }
    }

    static {
        up = false;
        down = false;
        forwards = false;
        backwards = false;
        left = false;
        right = false;
        sprint = false;
    }
}

