/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting.ingredient;

import com.blakebr0.ironjetpacks.init.ModRecipeSerializers;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;

public class JetpackTierIngredient
extends Ingredient {
    private final int tier;
    private ItemStack[] stacks;
    private IntList stacksPacked;

    public JetpackTierIngredient(int tier) {
        super(Stream.of(new Ingredient.Value[0]));
        this.tier = tier;
    }

    public ItemStack[] m_43908_() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return this.stacks;
    }

    public IntList m_43931_() {
        if (this.stacksPacked == null) {
            if (this.stacks == null) {
                this.initMatchingStacks();
            }
            this.stacksPacked = new IntArrayList(this.stacks.length);
            Arrays.stream(this.stacks).forEach(s -> this.stacksPacked.add(StackedContents.m_36496_((ItemStack)s)));
            this.stacksPacked.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stacksPacked;
    }

    public boolean test(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!JetpackRegistry.getInstance().getAllTiers().contains(this.tier)) {
            return stack.m_41619_();
        }
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41720_() != stack.m_41720_()) continue;
            Jetpack jetpack = JetpackUtils.getJetpack(stack);
            return jetpack != Jetpack.UNDEFINED && jetpack.tier == this.tier;
        }
        return false;
    }

    public boolean m_43947_() {
        return !(!JetpackRegistry.getInstance().getJetpacks().stream().noneMatch(j -> j.getTier() == this.tier) || this.stacks != null && this.stacks.length != 0 || this.stacksPacked != null && !this.stacksPacked.isEmpty());
    }

    public JsonElement m_43942_() {
        JsonArray json = new JsonArray();
        JetpackRegistry.getInstance().getJetpacks().stream().filter(j -> j.getTier() == this.tier).forEach(jetpack -> {
            JsonObject obj = new JsonObject();
            ItemStack stack = JetpackUtils.getItemForJetpack(jetpack);
            obj.addProperty("type", CraftingHelper.getID((IIngredientSerializer)StrictNBTIngredient.Serializer.INSTANCE).toString());
            obj.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
            obj.addProperty("count", (Number)stack.m_41613_());
            if (stack.m_41782_()) {
                obj.addProperty("nbt", stack.m_41783_().toString());
            }
            json.add((JsonElement)obj);
        });
        return json;
    }

    protected void invalidate() {
        this.stacks = null;
        this.stacksPacked = null;
    }

    public boolean isSimple() {
        return true;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.JETPACK_TIER_INGREDIENT;
    }

    private void initMatchingStacks() {
        this.stacks = (ItemStack[])JetpackRegistry.getInstance().getJetpacks().stream().filter(j -> j.getTier() == this.tier).map(JetpackUtils::getItemForJetpack).toArray(ItemStack[]::new);
    }

    public static class Serializer
    implements IIngredientSerializer<JetpackTierIngredient> {
        public JetpackTierIngredient parse(FriendlyByteBuf buffer) {
            return new JetpackTierIngredient(buffer.readInt());
        }

        public JetpackTierIngredient parse(JsonObject json) {
            return new JetpackTierIngredient(json.get("tier").getAsInt());
        }

        public void write(FriendlyByteBuf buffer, JetpackTierIngredient ingredient) {
            buffer.writeInt(ingredient.tier);
        }
    }
}

