/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.OptionButton;
import snownee.jade.gui.config.WailaOptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.entry.ConfigEntry;
import snownee.jade.util.ModIdentification;

public class PluginsConfigScreen
extends BaseOptionsScreen {
    public PluginsConfigScreen(Screen parent) {
        super(parent, (Component)Component.m_237115_((String)"gui.jade.plugin_settings"), PluginConfig.INSTANCE::save, PluginConfig.INSTANCE::reload);
    }

    @Override
    public WailaOptionsList createOptions() {
        WailaOptionsList options = new WailaOptionsList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 30, PluginConfig.INSTANCE::save);
        PluginConfig.INSTANCE.getNamespaces().forEach(namespace -> {
            String translationKey = "plugin_" + namespace;
            MutableComponent title = ModIdentification.NAMES.containsKey(namespace) ? Component.m_237113_((String)ModIdentification.getModName(namespace)) : Component.m_237115_((String)translationKey);
            options.add(new OptionButton((Component)title, new Button(0, 0, 100, 20, (Component)Component.m_237119_(), w -> this.f_96541_.m_91152_(PluginsConfigScreen.createPluginConfigScreen(this, namespace, true)))));
        });
        return options;
    }

    public static Screen createPluginConfigScreen(@Nullable Screen parent, final String namespace, boolean dontSave) {
        final String translationKey = "plugin_" + namespace;
        MutableComponent title = ModIdentification.NAMES.containsKey(namespace) ? Component.m_237113_((String)ModIdentification.getModName(namespace)) : Component.m_237115_((String)translationKey);
        return new BaseOptionsScreen(parent, (Component)title, dontSave ? null : PluginConfig.INSTANCE::save, dontSave ? null : PluginConfig.INSTANCE::reload){

            @Override
            public WailaOptionsList createOptions() {
                WailaOptionsList options;
                Set<ResourceLocation> keys;
                block3: {
                    block2: {
                        keys = PluginConfig.INSTANCE.getKeys(namespace);
                        options = new WailaOptionsList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 30);
                        if (Minecraft.m_91087_().f_91073_ == null || IWailaConfig.get().getGeneral().isDebug()) break block2;
                        if (ObjectDataCenter.serverConnected) break block3;
                    }
                    options.serverFeatures = (int)keys.stream().filter(Predicate.not(WailaClientRegistration.INSTANCE::isClientFeature)).count();
                }
                keys.stream().sorted(Comparator.comparingInt(arg_0 -> WailaCommonRegistration.INSTANCE.priorities.getSortedList().indexOf(arg_0))).forEach(i -> {
                    ConfigEntry<?> configEntry = PluginConfig.INSTANCE.getEntry((ResourceLocation)i);
                    OptionValue<?> entry = configEntry.createUI(options, translationKey + "." + i.m_135815_());
                    if (configEntry.isSynced()) {
                        entry.setDisabled(true);
                        entry.appendDescription(ChatFormatting.DARK_RED + I18n.m_118938_((String)"gui.jade.forced_plugin_config", (Object[])new Object[0]));
                    } else if (options.serverFeatures > 0 && !WailaClientRegistration.INSTANCE.isClientFeature((ResourceLocation)i)) {
                        entry.getTitle().m_7220_((Component)Component.m_237113_((String)"*").m_130940_(ChatFormatting.GRAY));
                    }
                    if (i.m_135815_().contains(".")) {
                        entry.indent = 12;
                    }
                });
                return options;
            }
        };
    }
}

