/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.gui.BaseContainer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonUtils {
    private static MinecraftServer server;

    static void initialize() {
        MinecraftForge.EVENT_BUS.addListener(e -> {
            server = e.getServer();
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            server = null;
        });
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static Level getLevel(ResourceKey<Level> resourceKey) {
        MinecraftServer server = CommonUtils.getServer();
        return server == null ? null : server.m_129880_(resourceKey);
    }

    public static RegistryAccess getRegistryAccess() {
        MinecraftServer server = CommonUtils.getServer();
        if (server == null && CommonUtils.getEnvironmentSide().isClient()) {
            Level level = ClientUtils.getWorld();
            return level == null ? null : level.m_5962_();
        }
        return server == null ? null : server.m_206579_();
    }

    public static CoreSide getEnvironmentSide() {
        return CoreSide.fromUnderlying(FMLEnvironment.dist);
    }

    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static void openContainer(final BaseContainer container) {
        Player player = container.player;
        if (!(container.player instanceof ServerPlayer)) {
            return;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237119_();
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                container.setContainerId(windowId);
                return container;
            }
        }, data -> container.getContainerType().writeContainer(container, (FriendlyByteBuf)data));
    }

    public static void closeContainer(Player player) {
        player.m_6915_();
    }

    public static Logger getLogger(String modid) {
        return LoggerFactory.getLogger((String)modid);
    }
}

