/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.forge;

import appeng.block.networking.EnergyCellBlockItem;
import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.client.render.SimpleModelLoader;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.client.render.crafting.CraftingMonitorRenderer;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.model.AutoRotatingBakedModel;
import appeng.core.AppEng;
import appeng.init.client.InitScreens;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.powered.AbstractPortableCell;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.MEGACraftingUnitType;
import gripe._90.megacells.block.MEGAPatternProviderBlock;
import gripe._90.megacells.client.render.MEGACraftingUnitModelProvider;
import gripe._90.megacells.core.Addons;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.integration.appbot.AppBotItems;
import gripe._90.megacells.integration.appmek.AppMekItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class MEGACellsClient {
    public MEGACellsClient() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::initScreens);
        bus.addListener(this::initRenderTypes);
        bus.addListener(this::initModels);
        bus.addListener(this::initModelRotation);
        bus.addListener(this::initItemColors);
    }

    private void initScreens(FMLClientSetupEvent ignoredEvent) {
        InitScreens.register(MEGAPatternProviderBlock.MENU, PatternProviderScreen::new, (String)"/screens/megacells/mega_pattern_provider.json");
    }

    private void initRenderTypes(FMLClientSetupEvent ignoredEvent) {
        for (MEGACraftingUnitType type : MEGACraftingUnitType.values()) {
            ItemBlockRenderTypes.setRenderLayer((Block)type.getDefinition().block(), (RenderType)RenderType.m_110463_());
        }
    }

    private void initModels(ModelEvent.RegisterGeometryLoaders event) {
        for (MEGACraftingUnitType type : MEGACraftingUnitType.values()) {
            event.register("block/crafting/" + type.getAffix() + "_formed", (IGeometryLoader)new SimpleModelLoader(() -> new CraftingCubeModel((AbstractCraftingUnitModelProvider)new MEGACraftingUnitModelProvider(type))));
        }
        BlockEntityRenderers.m_173590_(MEGABlockEntities.MEGA_CRAFTING_MONITOR, CraftingMonitorRenderer::new);
        ItemProperties.register((Item)MEGABlocks.MEGA_ENERGY_CELL.m_5456_(), (ResourceLocation)AppEng.makeId((String)"fill_level"), (is, level, entity, seed) -> {
            EnergyCellBlockItem energyCell = (EnergyCellBlockItem)MEGABlocks.MEGA_ENERGY_CELL.m_5456_();
            double curPower = energyCell.getAECurrentPower(is);
            double maxPower = energyCell.getAEMaxPower(is);
            return (float)(curPower / maxPower);
        });
    }

    private void initModelRotation(ModelEvent.BakingCompleted event) {
        Map modelRegistry = event.getModels();
        HashMap<String, Function<BakedModel, BakedModel>> customizers = new HashMap<String, Function<BakedModel, BakedModel>>();
        customizers.put(MEGABlocks.CRAFTING_MONITOR.id().m_135815_(), model -> model instanceof MonitorBakedModel ? model : new AutoRotatingBakedModel(model));
        customizers.put(MEGABlocks.MEGA_PATTERN_PROVIDER.id().m_135815_(), AutoRotatingBakedModel::new);
        for (ResourceLocation location : modelRegistry.keySet()) {
            if (!location.m_135827_().equals("megacells")) continue;
            BakedModel originalModel = (BakedModel)modelRegistry.get(location);
            Function customizer = (Function)customizers.get(location.m_135815_());
            if (customizer == null) continue;
            BakedModel newModel = (BakedModel)customizer.apply(originalModel);
            modelRegistry.put(location, newModel);
        }
    }

    private void initItemColors(RegisterColorHandlersEvent.Item event) {
        ArrayList cells = new ArrayList(MEGAItems.getItemCells());
        cells.addAll(MEGAItems.getFluidCells());
        cells.add(MEGAItems.BULK_ITEM_CELL);
        ArrayList portables = new ArrayList(MEGAItems.getItemPortables());
        portables.addAll(MEGAItems.getFluidPortables());
        if (MEGACells.PLATFORM.isAddonLoaded(Addons.APPMEK)) {
            cells.addAll(AppMekItems.getCells());
            portables.addAll(AppMekItems.getPortables());
            cells.add(AppMekItems.RADIOACTIVE_CHEMICAL_CELL);
        }
        if (MEGACells.PLATFORM.isAddonLoaded(Addons.APPBOT)) {
            cells.addAll(AppBotItems.getCells());
            portables.addAll(AppBotItems.getPortables());
        }
        event.register(BasicStorageCell::getColor, cells.toArray(new ItemLike[0]));
        event.register(AbstractPortableCell::getColor, portables.toArray(new ItemLike[0]));
    }
}

