/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LeafSettingGenerator
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;

    public LeafSettingGenerator(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void m_213708_(@NotNull CachedOutput cache) {
        Path path = this.generator.m_123916_();
        HashSet set = new HashSet();
        this.registerLeafSettingEntries(entry -> {
            if (!set.add(entry.id())) {
                throw new IllegalStateException("Duplicate leaf setting entry " + entry.id());
            }
            JsonObject object = new JsonObject();
            object.addProperty("spawnrate", (Number)entry.spawnRateFactor());
            object.addProperty("leaf_type", entry.leafType().toString());
            object.addProperty("consider_as_conifer", Boolean.valueOf(entry.considerAsConifer()));
            this.saveLeafSettingEntries(cache, object, path.resolve("assets/" + entry.id().m_135827_() + "/fallingleaves/settings/" + entry.id().m_135815_() + ".json"));
        });
    }

    public String m_6055_() {
        return "Falling Leaves leaves settings generator";
    }

    private void saveLeafSettingEntries(CachedOutput cache, JsonObject entryJson, Path path) {
        try {
            String s = GSON.toJson((JsonElement)entryJson);
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
            hashingoutputstream.write(s.getBytes(StandardCharsets.UTF_8));
            cache.m_213871_(path, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
        }
        catch (IOException ioExeption) {
            LOGGER.error("Couldn't save skill node {}", (Object)path, (Object)ioExeption);
        }
    }

    protected void registerLeafSettingEntries(Consumer<LeafSettingsEntry> consumer) {
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("minecraft", "spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("minecraft", "jungle_leaves"), 0.0));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "blue_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "cypress_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "fir_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "orange_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "pine_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "red_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "yellow_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "pink_cherry_leaves"), 1.4));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "skyris_leaves"), 1.4));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "white_cherry_leaves"), 1.4));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "cypress_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "hemlock_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "redwood_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "japenese_maple_shrub_leaves"), 0.0));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "jungle_palm_leaves"), 0.0));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "yucca_palm_leaves"), 0.0));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "sakura_leaves"), 1.4));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "fir_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "brown_autumnal_leaves"), 1.8));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "orange_autumnal_leaves"), 1.8));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "red_autumnal_leaves"), 1.8));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "yellow_autumnal_leaves"), 1.8));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("woods_and_mires", "pine_leaves"), 1.0, true));
    }
}

