/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.proxy;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.proxy.ClientProxyComponent;
import org.cyclops.cyclopscore.proxy.CommonProxyComponent;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.proxy.CommonProxy;

public class ClientProxy
extends ClientProxyComponent {
    public ClientProxy() {
        super((CommonProxyComponent)new CommonProxy());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ModBase getMod() {
        return EverlastingAbilities._instance;
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Post event) {
        LivingEntity entity = event.getEntity();
        if ((GeneralConfig.showEntityParticles && entity instanceof PathfinderMob || GeneralConfig.showPlayerParticles && entity instanceof Player) && !Minecraft.m_91087_().m_91104_() && entity.f_19853_.m_46467_() % 10L == 0L) {
            entity.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).ifPresent(abilityStore -> {
                if (!abilityStore.getAbilities().isEmpty()) {
                    Triple<Integer, Integer, Integer> abilityColors = AbilityHelpers.getAverageRarityColor(abilityStore);
                    float r = (float)((Integer)abilityColors.getLeft()).intValue() / 255.0f;
                    float g = (float)((Integer)abilityColors.getMiddle()).intValue() / 255.0f;
                    float b = (float)((Integer)abilityColors.getRight()).intValue() / 255.0f;
                    RandomSource rand = entity.f_19853_.f_46441_;
                    float scale = 0.5f - rand.m_188501_() * 0.3f;
                    float red = Math.max(0.0f, r - rand.m_188501_() * 0.1f);
                    float green = Math.max(0.0f, g - rand.m_188501_() * 0.1f);
                    float blue = Math.max(0.0f, b - rand.m_188501_() * 0.1f);
                    float ageMultiplier = (float)(rand.m_188500_() * 10.0 + 20.0);
                    double x = entity.m_20185_() - 0.1 + rand.m_188500_() * 0.2 + (double)(entity.m_20205_() / 2.0f * (float)(rand.m_188499_() ? 1 : -1));
                    double y = entity.m_20186_() + (double)entity.m_20206_() - 0.2 + rand.m_188500_() * 0.4;
                    double z = entity.m_20189_() - 0.1 + rand.m_188500_() * 0.2 + (double)(entity.m_20205_() / 2.0f * (float)(rand.m_188499_() ? 1 : -1));
                    double motionX = 0.02 - rand.m_188500_() * 0.04;
                    double motionY = 0.02 - rand.m_188500_() * 0.04;
                    double motionZ = 0.02 - rand.m_188500_() * 0.04;
                    Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, x, y, z, motionX, motionY, motionZ);
                }
            });
        }
    }
}

