/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.api.AbilityTypeAdapter;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class AbilityTypeSpecialMagnetize
extends AbilityTypeAdapter {
    private static final int TICK_MODULUS = 1;
    private final boolean moveXp;

    public AbilityTypeSpecialMagnetize(ICondition condition, String name, Rarity rarity, int maxLevel, int baseXpPerLevel, boolean obtainableOnPlayerSpawn, boolean obtainableOnMobSpawn, boolean obtainableOnCraft, boolean obtainableOnLoot, boolean moveXp) {
        super(condition, name, rarity, maxLevel, baseXpPerLevel, obtainableOnPlayerSpawn, obtainableOnMobSpawn, obtainableOnCraft, obtainableOnLoot);
        this.moveXp = moveXp;
    }

    @Override
    public Codec<? extends IAbilityType> codec() {
        return Objects.requireNonNull(RegistryEntries.ABILITYSERIALIZER_SPECIAL_MAGNETIZE);
    }

    public boolean isMoveXp() {
        return this.moveXp;
    }

    @Override
    public void onTick(Player player, int level) {
        Level world = player.f_19853_;
        if (!world.f_46443_ && !player.m_6047_() && player.f_19853_.m_46467_() % 1L == 0L) {
            double x = player.m_20185_();
            double y = player.m_20186_();
            double z = player.m_20189_();
            int area = level * 2;
            AABB box = new AABB(x, y, z, x, y, z).m_82377_((double)area, (double)area, (double)area);
            List entities = world.m_6249_((Entity)player, box, (Predicate)new com.google.common.base.Predicate<Entity>(){

                public boolean apply(Entity entity) {
                    return entity instanceof ItemEntity || AbilityTypeSpecialMagnetize.this.isMoveXp() && entity instanceof ExperienceOrb;
                }
            });
            for (Entity moveEntity : entities) {
                if ((!(moveEntity instanceof ItemEntity) || ((ItemEntity)moveEntity).m_32063_() || !this.canKineticateItem((ItemEntity)moveEntity)) && !(moveEntity instanceof ExperienceOrb)) continue;
                double dx = moveEntity.m_20185_() - x;
                double dy = moveEntity.m_20186_() - y + 1.0;
                double dz = moveEntity.m_20189_() - z;
                double strength = -1.0;
                double d = Mth.m_14116_((float)((float)(dx * dx + dy * dy + dz * dz)));
                if (!(d > 0.5)) continue;
                double m = 1.0 / (2.0 * Math.max(1.0, d));
                dx *= m;
                dy *= m;
                dz *= m;
                if (moveEntity instanceof ItemEntity && d < 5.0) {
                    ((ItemEntity)moveEntity).m_32010_(0);
                }
                moveEntity.m_20334_(dx * strength, moveEntity.f_19862_ ? 0.3 : dy * strength, dz * strength);
            }
        }
    }

    protected boolean canKineticateItem(ItemEntity entityItem) {
        return !entityItem.getPersistentData().m_128441_("PreventRemoteMovement");
    }
}

