/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.SoundTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.IScreenModuleUpdater;
import mcjty.rftoolsbase.api.screens.ITooltipInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StorageControlScreenModule
implements IScreenModule<ModuleDataStacks>,
ITooltipInfo,
IScreenModuleUpdater {
    private final ItemStackList stacks = ItemStackList.create((int)9);
    protected ResourceKey<Level> dim = Level.f_46428_;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private boolean starred = false;
    private int dirty = -1;

    public ModuleDataStacks getData(IScreenDataHelper helper, Level worldObj, long millis) {
        IStorageScanner scannerTileEntity = StorageControlScreenModule.getStorageScanner(worldObj, this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return null;
        }
        int[] amounts = new int[this.stacks.size()];
        for (int i = 0; i < this.stacks.size(); ++i) {
            amounts[i] = scannerTileEntity.countItems((ItemStack)this.stacks.get(i), this.starred);
        }
        return new ModuleDataStacks(amounts);
    }

    public static IStorageScanner getStorageScanner(Level worldObj, ResourceKey<Level> dim, BlockPos coordinate) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, dim);
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)coordinate)) {
            return null;
        }
        BlockEntity te = world.m_7702_(coordinate);
        if (te == null) {
            return null;
        }
        if (!(te instanceof IStorageScanner)) {
            return null;
        }
        return (IStorageScanner)te;
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        IStorageScanner te;
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (!tagCompound.m_128441_("stack" + i)) continue;
                this.stacks.set(i, (Object)ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("stack" + i)));
            }
        }
        if ((te = StorageControlScreenModule.getStorageScanner((Level)LevelTools.getOverworld(), dim, this.coordinate)) != null) {
            te.clearCachedCounts();
        }
    }

    private int getHighlightedStack(int hitx, int hity) {
        int i = 0;
        for (int yy = 0; yy < 3; ++yy) {
            int y = 7 + yy * 35;
            for (int xx = 0; xx < 3; ++xx) {
                boolean hilighted;
                int x = xx * 40;
                boolean bl = hilighted = hitx >= x + 8 && hitx <= x + 38 && hity >= y - 7 && hity <= y + 22;
                if (hilighted) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public List<String> getInfo(Level world, int x, int y) {
        int i;
        IStorageScanner te = StorageControlScreenModule.getStorageScanner(world, this.dim, this.coordinate);
        if (te != null && (i = this.getHighlightedStack(x, y)) != -1 && !((ItemStack)this.stacks.get(i)).m_41619_()) {
            return Collections.singletonList(ChatFormatting.GREEN + "Item: " + ChatFormatting.WHITE + ((ItemStack)this.stacks.get(i)).m_41786_());
        }
        return Collections.emptyList();
    }

    protected void setupCoordinateFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        this.starred = tagCompound.m_128471_("starred");
        if (tagCompound.m_128441_("monitorx")) {
            this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
            BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
            int dx = Math.abs(c.m_123341_() - pos.m_123341_());
            int dy = Math.abs(c.m_123342_() - pos.m_123342_());
            int dz = Math.abs(c.m_123343_() - pos.m_123343_());
            this.coordinate = c;
        }
    }

    public int getRfPerTick() {
        return (Integer)StorageScannerConfiguration.STORAGE_CONTROL_RFPERTICK.get();
    }

    private boolean isShown(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (ItemStack s : this.stacks) {
            if (!StorageControlScreenModule.isItemEqual(stack, s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEqual(ItemStack thisItem, ItemStack other) {
        if (other.m_41619_()) {
            return false;
        }
        return thisItem.m_41656_(other);
    }

    public CompoundTag update(CompoundTag tagCompound, Level world, Player player) {
        if (this.dirty >= 0) {
            CompoundTag newCompound = tagCompound.m_6426_();
            CompoundTag tc = new CompoundTag();
            ((ItemStack)this.stacks.get(this.dirty)).m_41739_(tc);
            newCompound.m_128365_("stack" + this.dirty, (Tag)tc);
            if (player != null) {
                SoundTools.playSound((Level)player.m_20193_(), (SoundEvent)SoundEvents.f_11871_, (double)player.m_20183_().m_123341_(), (double)player.m_20183_().m_123342_(), (double)player.m_20183_().m_123343_(), (double)1.0, (double)1.0);
            }
            this.dirty = -1;
            return newCompound;
        }
        return null;
    }

    public void mouseClick(Level world, int hitx, int hity, boolean clicked, Player player) {
        if (!clicked || player == null) {
            return;
        }
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Module is not linked to storage scanner!")), false);
            return;
        }
        IStorageScanner scannerTileEntity = StorageControlScreenModule.getStorageScanner(player.f_19853_, this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return;
        }
        if (hitx >= 0) {
            boolean insertAllActive;
            boolean insertStackActive;
            boolean bl = insertStackActive = hitx >= 0 && hitx < 60 && hity > 98;
            if (insertStackActive) {
                if (this.isShown(player.m_21120_(InteractionHand.MAIN_HAND))) {
                    ItemStack stack = scannerTileEntity.injectStackFromScreen(player.m_21120_(InteractionHand.MAIN_HAND), player);
                    player.m_21008_(InteractionHand.MAIN_HAND, stack);
                }
                player.f_36096_.m_38946_();
                return;
            }
            boolean bl2 = insertAllActive = hitx >= 60 && hity > 98;
            if (insertAllActive) {
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    if (!this.isShown(player.m_150109_().m_8020_(i))) continue;
                    ItemStack stack = scannerTileEntity.injectStackFromScreen(player.m_150109_().m_8020_(i), player);
                    player.m_150109_().m_6836_(i, stack);
                }
                player.f_36096_.m_38946_();
                return;
            }
            int i = this.getHighlightedStack(hitx, hity);
            if (i != -1) {
                if (((ItemStack)this.stacks.get(i)).m_41619_()) {
                    ItemStack heldItem = player.m_21205_();
                    if (!heldItem.m_41619_()) {
                        ItemStack stack = heldItem.m_41777_();
                        stack.m_41764_(1);
                        this.stacks.set(i, (Object)stack);
                        this.dirty = i;
                    }
                } else {
                    scannerTileEntity.giveToPlayerFromScreen((ItemStack)this.stacks.get(i), player.m_6144_(), player);
                }
            }
        }
    }

    public static class ModuleDataStacks
    implements IModuleData {
        public static final String ID = "rftoolsstorage:storage";
        private int[] amounts = null;

        public String getId() {
            return ID;
        }

        public ModuleDataStacks(int ... amountsIn) {
            this.amounts = amountsIn;
        }

        public ModuleDataStacks(ByteBuf buf) {
            int s = buf.readInt();
            this.amounts = new int[s];
            for (int i = 0; i < s; ++i) {
                this.amounts[i] = buf.readInt();
            }
        }

        public int getAmount(int idx) {
            return this.amounts[idx];
        }

        public void writeToBuf(FriendlyByteBuf buf) {
            buf.writeInt(this.amounts.length);
            for (int i : this.amounts) {
                buf.writeInt(i);
            }
        }
    }
}

