/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.stateinfo.additional;

import com.communi.suggestu.scena.core.fluid.FluidInformation;
import com.communi.suggestu.scena.core.registries.IPlatformRegistryManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.api.variant.state.IStateVariantProvider;
import mod.chiselsandbits.blockinformation.BlockInformation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public final class StateVariantManager
implements IStateVariantManager {
    private static final StateVariantManager INSTANCE = new StateVariantManager();
    private final Map<Supplier<Block>, IStateVariantProvider> preBakeProviders = new ConcurrentHashMap<Supplier<Block>, IStateVariantProvider>();
    private final Map<Block, IStateVariantProvider> providers = new ConcurrentHashMap<Block, IStateVariantProvider>();

    public static StateVariantManager getInstance() {
        return INSTANCE;
    }

    private StateVariantManager() {
    }

    @Override
    public IStateVariantManager registerProvider(Supplier<Block> block, IStateVariantProvider provider) {
        this.preBakeProviders.put(block, provider);
        return this;
    }

    private void bakeProviders() {
        if (!this.providers.isEmpty()) {
            return;
        }
        this.preBakeProviders.forEach((block, provider) -> this.providers.put((Block)block.get(), (IStateVariantProvider)provider));
        this.preBakeProviders.clear();
    }

    @Override
    public Optional<IStateVariant> getStateVariant(BlockState blockState, Optional<BlockEntity> blockEntity) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockState.m_60734_())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(blockState.m_60734_())).flatMap(provider -> provider.getStateVariant(blockState, blockEntity)).map(variant -> new WrappingStateVariant(blockState.m_60734_(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(FluidState fluidStateIn) {
        this.bakeProviders();
        if (!this.providers.containsKey(fluidStateIn.m_76188_().m_60734_())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(fluidStateIn.m_76188_().m_60734_())).flatMap(provider -> provider.getStateVariant(fluidStateIn)).map(variant -> new WrappingStateVariant(fluidStateIn.m_76188_().m_60734_(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(BlockState blockState, ItemStack itemStack) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockState.m_60734_())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(blockState.m_60734_())).flatMap(provider -> provider.getStateVariant(blockState, itemStack)).map(variant -> new WrappingStateVariant(blockState.m_60734_(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(FluidInformation fluidInformation) {
        this.bakeProviders();
        if (!this.providers.containsKey(fluidInformation.fluid().m_76145_().m_76188_().m_60734_())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(fluidInformation.fluid().m_76145_().m_76188_().m_60734_())).flatMap(provider -> provider.getStateVariant(fluidInformation)).map(variant -> new WrappingStateVariant(fluidInformation.fluid().m_76145_().m_76188_().m_60734_(), (IStateVariant)variant));
    }

    @Override
    public Collection<IBlockInformation> getAllDefaultVariants(BlockState state) {
        this.bakeProviders();
        if (!this.providers.containsKey(state.m_60734_())) {
            return Collections.emptyList();
        }
        return Optional.of(this.providers.get(state.m_60734_())).map(provider -> provider.getAllDefaultVariants(state)).stream().flatMap(Collection::stream).map(variant -> new WrappingStateVariant(state.m_60734_(), (IStateVariant)variant)).map(variant -> new BlockInformation(state, Optional.of(variant))).collect(Collectors.toSet());
    }

    @Override
    public CompoundTag serializeNBT(IStateVariant variant) {
        if (!(variant instanceof WrappingStateVariant)) {
            throw new IllegalArgumentException("additionalStateInfo must be a WrappingStateVariant");
        }
        WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)variant;
        this.bakeProviders();
        Block block = wrappingStateVariant.sourceBlock();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("block", IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)block).toString());
        tag.m_128365_("variant", (Tag)this.providers.get(block).serializeNBT(wrappingStateVariant.delegate()));
        return tag;
    }

    @Override
    public IStateVariant deserializeNBT(CompoundTag tag) {
        this.bakeProviders();
        Optional block = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(new ResourceLocation(tag.m_128461_("block")));
        if (block.isEmpty()) {
            throw new IllegalStateException("Missing block from variant!");
        }
        IStateVariant delegate = this.providers.get(block.get()).deserializeNBT(tag.m_128469_("variant"));
        return new WrappingStateVariant((Block)block.get(), delegate);
    }

    @Override
    public void serializeInto(FriendlyByteBuf packetBuffer, IStateVariant variant) {
        if (!(variant instanceof WrappingStateVariant)) {
            throw new IllegalArgumentException("additionalStateInfo must be a WrappingStateVariant");
        }
        WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)variant;
        this.bakeProviders();
        packetBuffer.m_130085_(IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)wrappingStateVariant.sourceBlock()));
        this.providers.get(wrappingStateVariant.sourceBlock()).serializeInto(packetBuffer, wrappingStateVariant.delegate());
    }

    @Override
    public IStateVariant deserializeFrom(FriendlyByteBuf packetBuffer) {
        this.bakeProviders();
        Optional block = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(packetBuffer.m_130281_());
        if (block.isEmpty()) {
            throw new IllegalStateException("Missing block from variant!");
        }
        IStateVariant stateVariant = this.providers.get(block.get()).deserializeFrom(packetBuffer);
        return new WrappingStateVariant((Block)block.get(), stateVariant);
    }

    @Override
    public Optional<ItemStack> getItemStack(IBlockInformation blockInformation) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockInformation.getBlockState().m_60734_())) {
            return Optional.empty();
        }
        return blockInformation.getVariant().flatMap(stateVariant -> this.providers.get(blockInformation.getBlockState().m_60734_()).getItemStack((IStateVariant)stateVariant));
    }

    @Override
    public Optional<FluidInformation> getFluidInformation(IBlockInformation blockInformation, long amount) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockInformation.getBlockState().m_60734_())) {
            return Optional.empty();
        }
        return blockInformation.getVariant().flatMap(variant -> this.providers.get(blockInformation.getBlockState().m_60734_()).getFluidInformation((IStateVariant)variant, amount));
    }

    @Override
    public Optional<Component> getName(IBlockInformation blockInformation) {
        this.bakeProviders();
        if (!this.providers.containsKey(blockInformation.getBlockState().m_60734_())) {
            return Optional.empty();
        }
        return blockInformation.getVariant().flatMap(variant -> this.providers.get(blockInformation.getBlockState().m_60734_()).getName((IStateVariant)variant));
    }

    public Optional<IStateVariant> unwrapVariant(Optional<IStateVariant> variant) {
        return variant.map(v -> {
            if (v instanceof WrappingStateVariant) {
                WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)v;
                return wrappingStateVariant.delegate();
            }
            return v;
        });
    }

    private record WrappingStateVariant(Block sourceBlock, IStateVariant delegate) implements IStateVariant
    {
        private static final Comparator<IStateVariant> VARIANT_COMPARATOR = Comparator.comparing(variant -> variant.getClass().getName()).thenComparing(Comparator.naturalOrder());

        @Override
        public int compareTo(@NotNull IStateVariant o) {
            if (o instanceof WrappingStateVariant) {
                WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)o;
                return VARIANT_COMPARATOR.compare(this.delegate, wrappingStateVariant.delegate);
            }
            return -1;
        }

        @Override
        public IStateVariant createSnapshot() {
            return new WrappingStateVariant(this.sourceBlock, (IStateVariant)this.delegate.createSnapshot());
        }
    }
}

