/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.config;

import com.communi.suggestu.scena.core.config.ConfigurationType;
import com.communi.suggestu.scena.core.config.IConfigurationBuilder;
import com.communi.suggestu.scena.core.config.IConfigurationManager;
import java.util.function.Supplier;
import mod.chiselsandbits.api.config.ICommonConfiguration;

public class CommonConfiguration
implements ICommonConfiguration {
    private final Supplier<Boolean> enableHelp;
    private final Supplier<Long> collisionBoxCacheSize;
    private final Supplier<Integer> blockSaveThreadCount;

    public CommonConfiguration() {
        IConfigurationBuilder builder = IConfigurationManager.getInstance().createBuilder(ConfigurationType.NOT_SYNCED, "chiselsandbits-common");
        this.enableHelp = builder.defineBoolean("help.enabled-in-tooltips", true);
        this.collisionBoxCacheSize = builder.defineLong("performance.caches.sizes.collision-boxes", 10000L, 0L, Long.MAX_VALUE);
        this.blockSaveThreadCount = builder.defineInteger("performance.saving.thread-count", Math.max(1, Runtime.getRuntime().availableProcessors()) / 2, 1, Runtime.getRuntime().availableProcessors());
        builder.setup();
    }

    @Override
    public Supplier<Boolean> getEnableHelp() {
        return this.enableHelp;
    }

    @Override
    public Supplier<Long> getCollisionBoxCacheSize() {
        return this.collisionBoxCacheSize;
    }

    @Override
    public Supplier<Integer> getBlockSaveThreadCount() {
        return this.blockSaveThreadCount;
    }
}

