/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.variant.state;

import com.communi.suggestu.scena.core.client.models.data.IBlockModelData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.client.variant.state.IClientStateVariantManager;
import mod.chiselsandbits.api.client.variant.state.IClientStateVariantProvider;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public final class ClientStateVariantManager
implements IClientStateVariantManager {
    private static final ClientStateVariantManager INSTANCE = new ClientStateVariantManager();
    private final Map<Supplier<Block>, IClientStateVariantProvider> preBakeProviders = new ConcurrentHashMap<Supplier<Block>, IClientStateVariantProvider>();
    private final Map<Block, IClientStateVariantProvider> providers = new ConcurrentHashMap<Block, IClientStateVariantProvider>();

    public static ClientStateVariantManager getInstance() {
        return INSTANCE;
    }

    private ClientStateVariantManager() {
    }

    @Override
    public IClientStateVariantManager registerStateVariantProvider(Supplier<Block> block, IClientStateVariantProvider provider) {
        this.preBakeProviders.put(block, provider);
        return this;
    }

    private void bakeProviders() {
        if (!this.providers.isEmpty()) {
            return;
        }
        this.preBakeProviders.forEach((block, provider) -> this.providers.put((Block)block.get(), (IClientStateVariantProvider)provider));
        this.preBakeProviders.clear();
    }

    @Override
    public IBlockModelData getBlockModelData(IBlockInformation blockInformation) {
        this.bakeProviders();
        if (blockInformation.getVariant().isEmpty() || !this.providers.containsKey(blockInformation.getBlockState().m_60734_())) {
            return IBlockModelData.empty();
        }
        return this.providers.get(blockInformation.getBlockState().m_60734_()).getBlockModelData(blockInformation.getVariant().get());
    }

    @Override
    public void appendHoverText(IBlockInformation blockInformation, Level level, List<Component> tooltip, TooltipFlag flags) {
        this.bakeProviders();
        if (blockInformation.getVariant().isEmpty() || !this.providers.containsKey(blockInformation.getBlockState().m_60734_())) {
            return;
        }
        ArrayList variantLines = new ArrayList();
        blockInformation.getVariant().ifPresent(variant -> this.providers.get(blockInformation.getBlockState().m_60734_()).appendHoverText((IStateVariant)variant, level, variantLines, flags));
        if (!variantLines.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.addAll(variantLines);
        }
    }
}

