/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.song.castle_in_the_sky.config.ConfigCommon;
import com.song.castle_in_the_sky.structures.CastlePlacement;
import com.song.castle_in_the_sky.structures.StructureRegister;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class CastleStructure
extends Structure {
    public static final Codec<CastleStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CastleStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, CastleStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    protected CastleStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int startY = (Integer)ConfigCommon.CASTLE_HEIGHT.get();
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        if (blockPos.m_123314_(new Vec3i(0, startY, 0), (double)((Integer)ConfigCommon.CASTLE_SPAWN_PROOF.get()).intValue())) {
            return Optional.empty();
        }
        BlockPos generatorPos = new BlockPos(0, 0, 0);
        ArrayList<Consumer> actions = new ArrayList<Consumer>();
        int idx = 0;
        for (int shift1 = 0; shift1 < 3; ++shift1) {
            for (int shift2 = 0; shift2 < 3; ++shift2) {
                for (int shiftY = 0; shiftY < 3; ++shiftY) {
                    String xyz = String.format("%d%d%d", shift1, shiftY, shift2);
                    Optional<Structure.GenerationStub> structurePiecesGenerator = CastlePlacement.addPieces(context, this.startPool, this.startJigsawName, this.size, blockPos.m_7918_(shift2 * 48, shiftY * 48, shift1 * 48), false, Optional.empty(), this.maxDistanceFromCenter, idx);
                    actions.add((Consumer)structurePiecesGenerator.get().f_226670_().left().get());
                    ++idx;
                }
            }
        }
        return Optional.of(new Structure.GenerationStub(blockPos, structurePiecesBuilder -> {
            for (Consumer action : actions) {
                action.accept(structurePiecesBuilder);
            }
        }));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructureRegister.CASTLE_IN_THE_SKY.get();
    }
}

