/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.client;

import cech12.bucketlib.client.model.UniversalBucketModel;
import cech12.bucketlib.util.BucketLibUtil;
import cech12.bucketlib.util.RegistryUtil;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="bucketlib", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    private ClientEvents() {
    }

    @SubscribeEvent
    public static void clientSetup(ModelEvent.RegisterGeometryLoaders event) {
        event.register("universal_bucket", (IGeometryLoader)UniversalBucketModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            event.addSprite(UniversalBucketModel.getContentTexture(BucketLibUtil.MILK_LOCATION));
            event.addSprite(UniversalBucketModel.getContentTexture(UniversalBucketModel.MISSING_LOWER_CONTENT));
            for (RegistryUtil.BucketBlock bucketBlock : RegistryUtil.getBucketBlocks()) {
                event.addSprite(UniversalBucketModel.getContentTexture(ForgeRegistries.BLOCKS.getKey((Object)bucketBlock.block())));
            }
            for (RegistryUtil.BucketEntity bucketEntity : RegistryUtil.getBucketEntities()) {
                event.addSprite(UniversalBucketModel.getContentTexture(ForgeRegistries.ENTITY_TYPES.getKey(bucketEntity.entityType())));
            }
        }
    }
}

