/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.render;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.ctx.TextureContextPosition;
import team.chisel.ctm.client.texture.render.AbstractTexture;
import team.chisel.ctm.client.texture.type.TextureTypeEldritch;
import team.chisel.ctm.client.util.Quad;

@ParametersAreNonnullByDefault
public class TextureEldritch
extends AbstractTexture<TextureTypeEldritch> {
    private static final Random rand = new Random();

    public TextureEldritch(TextureTypeEldritch type, TextureInfo info) {
        super(type, info);
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad quad, @Nullable ITextureContext context, int quadGoal) {
        Quad q = this.makeQuad(quad, context);
        Quad.UVs uvs = q.getUvs();
        Vec2 min = new Vec2(uvs.getMinU(), uvs.getMinV());
        Vec2 max = new Vec2(uvs.getMaxU(), uvs.getMaxV());
        Direction facing = quad.m_111306_();
        BlockPos pos = context == null ? BlockPos.f_121853_ : ((TextureContextPosition)context).getPosition();
        rand.setSeed(Mth.m_14057_((Vec3i)pos) + (long)facing.ordinal());
        float offx = this.offsetRand();
        float offy = this.offsetRand();
        Quad[] subdiv = q.subdivide(4);
        for (int i = 0; i < subdiv.length; ++i) {
            Quad quadrant = subdiv[i];
            for (int j = 0; quadrant != null && j < 4; ++j) {
                Vec2 uv = quadrant.getUv(j);
                if (uv.f_82470_ == min.f_82470_ || uv.f_82470_ == max.f_82470_ || uv.f_82471_ == min.f_82471_ || uv.f_82471_ == max.f_82471_) continue;
                float xinterp = Quad.normalize(min.f_82470_, max.f_82470_, uv.f_82470_);
                float yinterp = Quad.normalize(min.f_82471_, max.f_82471_, uv.f_82471_);
                uv = new Vec2(Quad.lerp(min.f_82470_, max.f_82470_, xinterp += offx), Quad.lerp(min.f_82471_, max.f_82471_, yinterp += offy));
                subdiv[i] = quadrant.withUv(j, uv);
            }
        }
        return Arrays.stream(subdiv).filter(Objects::nonNull).map(Quad::rebake).toList();
    }

    private float offsetRand() {
        return (float)rand.nextGaussian() * 0.08f;
    }
}

