/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.lib.api.ContainerType;
import cofh.lib.api.item.ICoFHItem;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.util.RSAEnergyHelper;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public interface IFluxItem
extends ICoFHItem,
IEnergyContainerItem {
    public static final int ENERGY_PER_USE = 500;
    public static final int ENERGY_PER_USE_EMPOWERED = 2000;

    default public Capability<? extends IEnergyStorage> getEnergyCapability() {
        return RSAEnergyHelper.getBaseEnergySystem();
    }

    default public int getEnergyPerUse(boolean empowered) {
        return empowered ? 2000 : 500;
    }

    default public boolean hasEnergy(ItemStack stack, int amount) {
        return this.getEnergyStored(stack) >= amount;
    }

    default public boolean hasEnergy(ItemStack stack, boolean empowered) {
        return this.hasEnergy(stack, this.getEnergyPerUse(empowered));
    }

    default public boolean useEnergy(ItemStack stack, int amount, boolean simulate) {
        if (simulate) {
            return true;
        }
        if (this.hasEnergy(stack, amount)) {
            this.extractEnergy(stack, amount, false);
            return true;
        }
        return false;
    }

    default public boolean useEnergy(ItemStack stack, int amount, Entity entity) {
        return this.useEnergy(stack, amount, Utils.isCreativePlayer((Entity)entity));
    }

    default public boolean useEnergy(ItemStack stack, boolean empowered, boolean simulate) {
        return this.useEnergy(stack, this.getEnergyPerUse(empowered), simulate);
    }

    default public boolean useEnergy(ItemStack stack, boolean empowered, @Nullable Entity entity) {
        return this.useEnergy(stack, this.getEnergyPerUse(empowered), Utils.isCreativePlayer((Entity)entity));
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.m_41720_() != oldStack.m_41720_() || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0;
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    default public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        this.useEnergy(stack, Math.min(this.getEnergyStored(stack), amount * this.getEnergyPerUse(false)), (Entity)entity);
        return 0;
    }

    default public boolean isBarVisible(ItemStack stack) {
        return this.getEnergyStored(stack) > 0;
    }

    default public int getBarColor(ItemStack stack) {
        return 0xD01010;
    }

    default public int getBarWidth(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 0;
        }
        return (int)Math.round(13.0 * (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack));
    }

    default public float getChargedModelProperty(ItemStack stack, Level world, LivingEntity entity, int seed) {
        return this.hasEnergy(stack, false) ? 1.0f : 0.0f;
    }

    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this, this.getEnergyCapability());
    }

    default public void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean creative = this.isCreative(stack, ContainerType.ENERGY);
        if (this.getMaxEnergyStored(stack) > 0) {
            tooltip.add((Component)(creative ? StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.energy") + ": ")).m_7220_((Component)StringHelper.getTextComponent((String)"info.cofh.infinite").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC)) : StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.energy") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " " + StringHelper.localize((String)"info.cofh.unit_rf")))));
        }
        this.addEnergyTooltip(stack, worldIn, tooltip, flagIn, this.getExtract(stack), this.getReceive(stack), creative);
    }

    public static DamageSource fluxDirectDamage(LivingEntity attacker) {
        return new EntityDamageSource("flux", (Entity)attacker).m_19380_();
    }

    public static DamageSource fluxRangedDamage(Projectile projectile, @Nullable Entity shooter) {
        return new IndirectEntityDamageSource("flux", (Entity)projectile, shooter).m_19366_().m_19380_();
    }
}

