/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.config.CoreClientConfig;
import cofh.core.item.ILeftClickHandlerItem;
import cofh.core.util.ProxyUtils;
import cofh.lib.item.SwordItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.entity.FluxSlash;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;

public class FluxSwordItem
extends SwordItemCoFH
implements IMultiModeFluxItem,
ILeftClickHandlerItem {
    protected final float damage = this.m_43299_();
    protected final float attackSpeed;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxSwordItem(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getEnchantmentValue(stack) > 0;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return this.hasEnergy(stack, false) && super.canPerformAction(stack, action);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((Level)worldIn) && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.hasEnergy(stack, this.getEnergyPerUse(this.isEmpowered(stack))) && super.isCorrectToolForDrops(stack, state);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    protected boolean canSweepAttack(Player player) {
        return player.m_36403_(0.5f) > 0.9f && !player.m_20142_();
    }

    protected void shootFluxSlash(ItemStack stack, Player player) {
        if (!this.isEmpowered(stack)) {
            return;
        }
        if (this.useEnergy(stack, true, player.f_36077_.f_35937_)) {
            Level world = player.f_19853_;
            FluxSlash projectile = new FluxSlash(world, (LivingEntity)player, Utils.getItemEnchantmentLevel((Enchantment)Enchantments.f_44983_, (ItemStack)stack));
            world.m_7967_((Entity)projectile);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarWidth(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    public void onLeftClick(Player player, ItemStack stack) {
        if (this.canSweepAttack(player) && this.isEmpowered(stack)) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
            this.shootFluxSlash(stack, player);
        }
    }
}

