/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.prism.SlopedPrismSkipPredicate;

public final class PrismSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        if (side == dir.m_122424_()) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        if (axis == dir.m_122434_() || side.m_122434_() != axis) {
            return false;
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_PRISM -> PrismSkipPredicate.testAgainstPrism(level, pos, state, dir, axis, adjState, side);
                case BlockType.FRAMED_SLOPED_PRISM -> PrismSkipPredicate.testAgainstSlopedPrism(level, pos, state, dir, axis, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM -> PrismSkipPredicate.testAgainstDoublePrism(level, pos, state, dir, axis, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPED_PRISM -> PrismSkipPredicate.testAgainstDoubleSlopedPrism(level, pos, state, dir, axis, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstPrism(BlockGetter level, BlockPos pos, BlockState state, Direction dir, Direction.Axis axis, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction.Axis adjAxis = (Direction.Axis)adjState.m_61143_((Property)BlockStateProperties.f_61365_);
        if (PrismSkipPredicate.getTriDir(dir, axis, side).isEqualTo(PrismSkipPredicate.getTriDir(adjDir, adjAxis, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlopedPrism(BlockGetter level, BlockPos pos, BlockState state, Direction dir, Direction.Axis axis, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction adjOrientation = (Direction)adjState.m_61143_((Property)PropertyHolder.ORIENTATION);
        if (PrismSkipPredicate.getTriDir(dir, axis, side).isEqualTo(SlopedPrismSkipPredicate.getTriDir(adjDir, adjOrientation, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePrism(BlockGetter level, BlockPos pos, BlockState state, Direction dir, Direction.Axis axis, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PrismSkipPredicate.testAgainstPrism(level, pos, state, dir, axis, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstDoubleSlopedPrism(BlockGetter level, BlockPos pos, BlockState state, Direction dir, Direction.Axis axis, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PrismSkipPredicate.testAgainstSlopedPrism(level, pos, state, dir, axis, (BlockState)states.m_14418_(), side);
    }

    public static HalfDir getTriDir(Direction dir, Direction.Axis axis, Direction side) {
        if (dir.m_122434_() != axis && side.m_122434_() == axis) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

