/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.pillar.FramedDiagonalFenceModel;

public class FramedFenceModel
extends FramedBlockModel {
    private final boolean north;
    private final boolean east;
    private final boolean south;
    private final boolean west;

    protected FramedFenceModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.north = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
        this.east = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
        this.south = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
        this.west = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).export(quadMap.get(quadDir));
        } else {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadDir.m_122427_(), 0.625f)).apply(Modifiers.cutSideLeftRight(quadDir.m_122428_(), 0.625f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
        }
        FramedFenceModel.createFenceBars(quadMap, quad, Direction.NORTH, this.north);
        FramedFenceModel.createFenceBars(quadMap, quad, Direction.EAST, this.east);
        FramedFenceModel.createFenceBars(quadMap, quad, Direction.SOUTH, this.south);
        FramedFenceModel.createFenceBars(quadMap, quad, Direction.WEST, this.west);
    }

    private static void createFenceBars(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean active) {
        if (!active) {
            return;
        }
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir)) {
            QuadModifier mod = QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(dir.m_122424_(), 0.375f)).apply(Modifiers.cutTopBottom(dir.m_122427_(), 0.5625f)).apply(Modifiers.cutTopBottom(dir.m_122428_(), 0.5625f));
            mod.apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.9375f : 0.25f)).export(quadMap.get(null));
            mod.apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.5625f : 0.625f)).export(quadMap.get(null));
        } else if (quadDir == dir.m_122427_() || quadDir == dir.m_122428_()) {
            boolean neg = !Utils.isPositive(dir);
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(neg ? 0.0f : 0.625f, 0.375f, neg ? 0.375f : 1.0f, 0.5625f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(neg ? 0.0f : 0.625f, 0.75f, neg ? 0.375f : 1.0f, 0.9375f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
        } else if (quadDir == dir) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.4375f, 0.375f, 0.5625f, 0.5625f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.4375f, 0.75f, 0.5625f, 0.9375f)).export(quadMap.get(quadDir));
        }
    }

    public static BakedModel createFenceModel(BlockState state, BakedModel baseModel) {
        if (ModList.get().isLoaded("diagonalfences")) {
            return new FramedDiagonalFenceModel(state, baseModel);
        }
        return new FramedFenceModel(state, baseModel);
    }
}

