/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import com.mojang.math.Vector3f;
import fuzs.diagonalfences.api.world.level.block.DiagonalBlock;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.pillar.FramedFenceModel;

public class FramedDiagonalFenceModel
extends FramedFenceModel {
    private final boolean northEast;
    private final boolean southEast;
    private final boolean northWest;
    private final boolean southWest;

    FramedDiagonalFenceModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        boolean hasProps = state.m_60734_() instanceof DiagonalBlock && ((DiagonalBlock)state.m_60734_()).hasProperties();
        this.northEast = hasProps && (Boolean)state.m_61143_((Property)DiagonalBlock.NORTH_EAST) != false;
        this.southEast = hasProps && (Boolean)state.m_61143_((Property)DiagonalBlock.SOUTH_EAST) != false;
        this.northWest = hasProps && (Boolean)state.m_61143_((Property)DiagonalBlock.NORTH_WEST) != false;
        this.southWest = hasProps && (Boolean)state.m_61143_((Property)DiagonalBlock.SOUTH_WEST) != false;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        super.transformQuad(quadMap, quad);
        FramedDiagonalFenceModel.createDiagonalFenceBars(quadMap, quad, Direction.NORTH, this.northEast);
        FramedDiagonalFenceModel.createDiagonalFenceBars(quadMap, quad, Direction.EAST, this.southEast);
        FramedDiagonalFenceModel.createDiagonalFenceBars(quadMap, quad, Direction.SOUTH, this.southWest);
        FramedDiagonalFenceModel.createDiagonalFenceBars(quadMap, quad, Direction.WEST, this.northWest);
    }

    private static void createDiagonalFenceBars(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean active) {
        if (!active) {
            return;
        }
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quadDir)) {
            QuadModifier mod = QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(dir.m_122424_(), 0.4375f)).apply(Modifiers.cutTopBottom(dir.m_122427_(), 0.5625f)).apply(Modifiers.cutTopBottom(dir.m_122428_(), 0.5625f)).apply(FramedDiagonalFenceModel.rotate(dir));
            mod.apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.9375f : 0.25f)).export(quadMap.get(null));
            mod.apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.5625f : 0.625f)).export(quadMap.get(null));
        } else if (quadDir == dir.m_122427_() || quadDir == dir.m_122428_()) {
            boolean neg = !Utils.isPositive(dir);
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(neg ? 0.0f : 0.5625f, 0.375f, neg ? 0.4375f : 1.0f, 0.5625f)).apply(Modifiers.setPosition(0.5625f)).apply(FramedDiagonalFenceModel.rotate(dir)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(neg ? 0.0f : 0.5625f, 0.75f, neg ? 0.4375f : 1.0f, 0.9375f)).apply(Modifiers.setPosition(0.5625f)).apply(FramedDiagonalFenceModel.rotate(dir)).export(quadMap.get(null));
        } else if (quadDir == dir) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.4375f, 0.375f, 0.5625f, 0.5625f)).apply(FramedDiagonalFenceModel.rotate(dir)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.4375f, 0.75f, 0.5625f, 0.9375f)).apply(FramedDiagonalFenceModel.rotate(dir)).export(quadMap.get(null));
        }
    }

    private static QuadModifier.Modifier rotate(Direction dir) {
        return Modifiers.rotateCentered(Direction.Axis.Y, -45.0f, true, new Vector3f((float)dir.m_122429_(), 1.0f, (float)dir.m_122431_()));
    }
}

