/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.ConfigValueList;
import codechicken.lib.math.MathHelper;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Optional;

public interface ListRestriction {
    public Optional<Failure> test(ConfigValueList var1);

    public String describe();

    public static ListRestriction intRange(int min, int max) {
        return new IntRange(min, max);
    }

    public static ListRestriction doubleRange(double min, double max) {
        return new DoubleRange(min, max);
    }

    public record IntRange(int min, int max) implements ListRestriction
    {
        public IntRange {
            if (min > max) {
                throw new IllegalArgumentException("Min cannot be larger than max.");
            }
        }

        @Override
        public Optional<Failure> test(ConfigValueList configValue) {
            IntIterator iter = configValue.getInts().intIterator();
            int i = 0;
            while (iter.hasNext()) {
                int val = iter.nextInt();
                if (!MathHelper.between(this.min, val, this.max)) {
                    return Optional.of(new Failure(i, val));
                }
                ++i;
            }
            return Optional.empty();
        }

        @Override
        public String describe() {
            return "[ " + this.min + " ~ " + this.max + " ]";
        }
    }

    public record DoubleRange(double min, double max) implements ListRestriction
    {
        public DoubleRange {
            if (min > max) {
                throw new IllegalArgumentException("Min cannot be larger than max.");
            }
        }

        @Override
        public Optional<Failure> test(ConfigValueList configValue) {
            DoubleIterator iter = configValue.getDoubles().doubleIterator();
            int i = 0;
            while (iter.hasNext()) {
                double val = iter.nextDouble();
                if (!MathHelper.between(this.min, val, this.max)) {
                    return Optional.of(new Failure(i, val));
                }
                ++i;
            }
            return Optional.empty();
        }

        @Override
        public String describe() {
            return "[ " + this.min + " ~ " + this.max + " ]";
        }
    }

    public record Failure(int index, Object value) {
    }
}

