/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter.acceptor;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorInfo;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class AcceptorCache<ACCEPTOR>
extends AbstractAcceptorCache<ACCEPTOR, AcceptorInfo<ACCEPTOR>> {
    public AcceptorCache(Transmitter<ACCEPTOR, ?, ?> transmitter, TileEntityTransmitter transmitterTile) {
        super(transmitter, transmitterTile);
    }

    protected void updateCachedAcceptorAndListen(Direction side, BlockEntity acceptorTile, LazyOptional<ACCEPTOR> acceptor) {
        this.updateCachedAcceptorAndListen(side, acceptorTile, acceptor, acceptor, true);
    }

    protected void updateCachedAcceptorAndListen(Direction side, BlockEntity acceptorTile, LazyOptional<ACCEPTOR> acceptor, LazyOptional<?> sourceAcceptor, boolean sourceIsSame) {
        boolean dirtyAcceptor = false;
        if (this.cachedAcceptors.containsKey(side)) {
            AcceptorInfo acceptorInfo = (AcceptorInfo)this.cachedAcceptors.get(side);
            if (acceptorTile != acceptorInfo.getTile()) {
                this.cachedAcceptors.put(side, new AcceptorInfo<ACCEPTOR>(acceptorTile, sourceAcceptor, acceptor));
                dirtyAcceptor = true;
            } else if (sourceAcceptor != acceptorInfo.sourceAcceptor) {
                acceptorInfo.updateAcceptor(sourceAcceptor, acceptor);
                dirtyAcceptor = true;
            }
        } else {
            this.cachedAcceptors.put(side, new AcceptorInfo<ACCEPTOR>(acceptorTile, sourceAcceptor, acceptor));
            dirtyAcceptor = true;
        }
        if (dirtyAcceptor) {
            this.transmitter.markDirtyAcceptor(side);
            NonNullConsumer refreshListener = this.getRefreshListener(side);
            if (sourceIsSame) {
                acceptor.addListener(refreshListener);
            } else {
                CapabilityUtils.addListener(sourceAcceptor, refreshListener);
            }
        }
    }

    @Override
    public LazyOptional<ACCEPTOR> getConnectedAcceptor(Direction side) {
        AcceptorInfo acceptorInfo;
        if (this.cachedAcceptors.containsKey(side) && !(acceptorInfo = (AcceptorInfo)this.cachedAcceptors.get(side)).getTile().m_58901_()) {
            return acceptorInfo.acceptor;
        }
        return LazyOptional.empty();
    }

    @Nullable
    public BlockEntity getConnectedAcceptorTile(Direction side) {
        BlockEntity tile;
        if (this.cachedAcceptors.containsKey(side) && !(tile = ((AcceptorInfo)this.cachedAcceptors.get(side)).getTile()).m_58901_()) {
            return tile;
        }
        return null;
    }

    public boolean isAcceptorAndListen(@Nullable BlockEntity tile, Direction side, Capability<ACCEPTOR> capability) {
        LazyOptional<ACCEPTOR> acceptor = CapabilityUtils.getCapability((ICapabilityProvider)tile, capability, side.m_122424_());
        if (acceptor.isPresent()) {
            this.updateCachedAcceptorAndListen(side, tile, acceptor);
            return true;
        }
        return false;
    }

    public static class AcceptorInfo<ACCEPTOR>
    extends AbstractAcceptorInfo {
        private LazyOptional<?> sourceAcceptor;
        private LazyOptional<ACCEPTOR> acceptor;

        private AcceptorInfo(BlockEntity tile, LazyOptional<?> sourceAcceptor, LazyOptional<ACCEPTOR> acceptor) {
            super(tile);
            this.acceptor = acceptor;
            this.sourceAcceptor = sourceAcceptor;
        }

        private void updateAcceptor(LazyOptional<?> sourceAcceptor, LazyOptional<ACCEPTOR> acceptor) {
            this.sourceAcceptor = sourceAcceptor;
            this.acceptor = acceptor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AcceptorInfo)) return false;
            AcceptorInfo other = (AcceptorInfo)o;
            if (!this.getTile().equals(other.getTile())) return false;
            if (!this.sourceAcceptor.equals(other.sourceAcceptor)) return false;
            if (!this.acceptor.equals(other.acceptor)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.getTile(), this.sourceAcceptor, this.acceptor);
        }
    }
}

