/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.predicate;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.Set;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.ModuleData;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.item.predicate.CustomItemPredicate;
import mekanism.common.util.RegistryUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class MaxedModuleContainerItemPredicate<ITEM extends Item>
extends CustomItemPredicate {
    public static final ResourceLocation ID = Mekanism.rl("maxed_module_container");
    private final Set<ModuleData<?>> supportedModules;
    private final ITEM item;

    public MaxedModuleContainerItemPredicate(ITEM item) {
        this.item = item;
        this.supportedModules = MekanismAPI.getModuleHelper().getSupported(new ItemStack(item));
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    public boolean m_45049_(@NotNull ItemStack stack) {
        Reference2IntMap<ModuleData<?>> installedCounts;
        if (stack.m_41720_() == this.item && (installedCounts = ModuleHelper.INSTANCE.loadAllCounts(stack)).keySet().containsAll(this.supportedModules)) {
            for (Reference2IntMap.Entry entry : installedCounts.reference2IntEntrySet()) {
                if (entry.getIntValue() == ((ModuleData)entry.getKey()).getMaxStackSize()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public JsonObject serializeToJson() {
        JsonObject object = super.serializeToJson();
        object.addProperty("item", RegistryUtils.getName(this.item).toString());
        return object;
    }

    public static MaxedModuleContainerItemPredicate<?> fromJson(JsonObject json) {
        String itemName = GsonHelper.m_13906_((JsonObject)json, (String)"item");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item instanceof IModuleContainerItem) {
            return new MaxedModuleContainerItemPredicate<Item>((Item)((IModuleContainerItem)item));
        }
        throw new JsonParseException("Specified item is not a module container item.");
    }
}

