/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot.chemical;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class ChemicalInventorySlot<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends BasicInventorySlot {
    protected final Supplier<Level> worldSupplier;
    protected final IChemicalTank<CHEMICAL, STACK> chemicalTank;

    @Nullable
    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> HANDLER getCapability(ItemStack stack, Capability<HANDLER> capability) {
        return (HANDLER)(stack.m_41619_() ? null : (IChemicalHandler)stack.getCapability(capability).resolve().orElse(null));
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>> STACK getPotentialConversion(IMekanismRecipeTypeProvider<RECIPE, InputRecipeCache.SingleItem<RECIPE>> recipeType, @Nullable Level world, ItemStack itemStack, STACK empty) {
        ItemStackToChemicalRecipe foundRecipe = (ItemStackToChemicalRecipe)recipeType.getInputCache().findTypeBasedRecipe(world, itemStack);
        return foundRecipe == null ? empty : foundRecipe.getOutput(itemStack);
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NotNull ItemStack> getFillOrConvertExtractPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, Function<@NotNull ItemStack, IChemicalHandler<CHEMICAL, STACK>> handlerFunction, Function<ItemStack, STACK> potentialConversionSupplier) {
        return stack -> {
            ChemicalStack conversion;
            IChemicalHandler handler = (IChemicalHandler)handlerFunction.apply((ItemStack)stack);
            if (handler != null) {
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    if (!chemicalTank.isValid(handler.getChemicalInTank(tank))) continue;
                    return false;
                }
            }
            return (conversion = (ChemicalStack)potentialConversionSupplier.apply((ItemStack)stack)).isEmpty() || !chemicalTank.isValid(conversion);
        };
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NotNull ItemStack> getFillOrConvertInsertPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, Function<@NotNull ItemStack, IChemicalHandler<CHEMICAL, STACK>> handlerFunction, Function<ItemStack, STACK> potentialConversionSupplier) {
        return stack -> {
            if (ChemicalInventorySlot.fillInsertCheck(chemicalTank, (IChemicalHandler)handlerFunction.apply((ItemStack)stack))) {
                return true;
            }
            ChemicalStack conversion = (ChemicalStack)potentialConversionSupplier.apply((ItemStack)stack);
            if (conversion.isEmpty()) {
                return false;
            }
            if (chemicalTank.insert(conversion, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < conversion.getAmount()) {
                return true;
            }
            return chemicalTank.getNeeded() == 0L && chemicalTank.isTypeEqual((Object)conversion) && chemicalTank.isValid(conversion);
        };
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NotNull ItemStack> getFillExtractPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, Function<@NotNull ItemStack, IChemicalHandler<CHEMICAL, STACK>> handlerFunction) {
        return stack -> {
            IChemicalHandler handler = (IChemicalHandler)handlerFunction.apply((ItemStack)stack);
            if (handler != null) {
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    Object storedChemical = handler.getChemicalInTank(tank);
                    if (((ChemicalStack)storedChemical).isEmpty() || !chemicalTank.isValid(storedChemical)) continue;
                    return false;
                }
            }
            return true;
        };
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean fillInsertCheck(IChemicalTank<CHEMICAL, STACK> chemicalTank, @Nullable IChemicalHandler<CHEMICAL, STACK> handler) {
        if (handler != null) {
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                STACK chemicalInTank = handler.getChemicalInTank(tank);
                if (((ChemicalStack)chemicalInTank).isEmpty() || ((ChemicalStack)chemicalTank.insert(chemicalInTank, Action.SIMULATE, AutomationType.INTERNAL)).getAmount() >= ((ChemicalStack)chemicalInTank).getAmount()) continue;
                return true;
            }
        }
        return false;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NotNull ItemStack> getDrainInsertPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, Function<@NotNull ItemStack, IChemicalHandler<CHEMICAL, STACK>> handlerFunction) {
        return stack -> {
            IChemicalHandler handler = (IChemicalHandler)handlerFunction.apply((ItemStack)stack);
            if (handler != null) {
                if (chemicalTank.isEmpty()) {
                    for (int tank = 0; tank < handler.getTanks(); ++tank) {
                        if (((ChemicalStack)handler.getChemicalInTank(tank)).getAmount() >= handler.getTankCapacity(tank)) continue;
                        return true;
                    }
                    return false;
                }
                return ((ChemicalStack)handler.insertChemical(chemicalTank.getStack(), Action.SIMULATE)).getAmount() < chemicalTank.getStored();
            }
            return false;
        };
    }

    protected ChemicalInventorySlot(IChemicalTank<CHEMICAL, STACK> chemicalTank, Supplier<Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.setSlotType(ContainerSlotType.EXTRA);
        this.chemicalTank = chemicalTank;
        this.worldSupplier = worldSupplier;
    }

    @Nullable
    protected abstract IChemicalHandler<CHEMICAL, STACK> getCapability();

    @Nullable
    protected ItemStackToChemicalRecipe<CHEMICAL, STACK> getConversionRecipe(@Nullable Level world, ItemStack stack) {
        return null;
    }

    public void fillTankOrConvert() {
        STACK output;
        ItemStack itemInput;
        ItemStackToChemicalRecipe<CHEMICAL, STACK> foundRecipe;
        if (!(this.isEmpty() || this.chemicalTank.getNeeded() <= 0L || this.fillTankFromItem() || (foundRecipe = this.getConversionRecipe(this.worldSupplier.get(), this.current)) == null || (itemInput = foundRecipe.getInput().getMatchingInstance(this.current)).m_41619_() || ((ChemicalStack)(output = foundRecipe.getOutput(itemInput))).isEmpty() || !((ChemicalStack)this.chemicalTank.insert(output, Action.SIMULATE, AutomationType.MANUAL)).isEmpty())) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)this.chemicalTank.insert(output, Action.EXECUTE, AutomationType.MANUAL)).getAmount(), 0L);
            int amountUsed = itemInput.m_41613_();
            MekanismUtils.logMismatchedStackSize(this.shrinkStack(amountUsed, Action.EXECUTE), amountUsed);
        }
    }

    public void fillTank() {
        ChemicalInventorySlot.fillChemicalTank(this, this.chemicalTank, this.getCapability());
    }

    public boolean fillTankFromItem() {
        return ChemicalInventorySlot.fillChemicalTankFromItem(this, this.chemicalTank, this.getCapability());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void fillChemicalTank(IInventorySlot slot, IChemicalTank<CHEMICAL, STACK> chemicalTank, @Nullable IChemicalHandler<CHEMICAL, STACK> handler) {
        if (!slot.isEmpty() && chemicalTank.getNeeded() > 0L) {
            ChemicalInventorySlot.fillChemicalTankFromItem(slot, chemicalTank, handler);
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean fillChemicalTankFromItem(IInventorySlot slot, IChemicalTank<CHEMICAL, STACK> chemicalTank, @Nullable IChemicalHandler<CHEMICAL, STACK> handler) {
        if (handler != null) {
            boolean didTransfer = false;
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                STACK extractedChemical;
                STACK chemicalInItem = handler.getChemicalInTank(tank);
                if (((ChemicalStack)chemicalInItem).isEmpty()) continue;
                STACK simulatedRemainder = chemicalTank.insert(chemicalInItem, Action.SIMULATE, AutomationType.INTERNAL);
                long chemicalInItemAmount = ((ChemicalStack)chemicalInItem).getAmount();
                long remainder = ((ChemicalStack)simulatedRemainder).getAmount();
                if (remainder >= chemicalInItemAmount || ((ChemicalStack)(extractedChemical = handler.extractChemical(tank, chemicalInItemAmount - remainder, Action.EXECUTE))).isEmpty()) continue;
                MekanismUtils.logMismatchedStackSize(((ChemicalStack)chemicalTank.insert(extractedChemical, Action.EXECUTE, AutomationType.INTERNAL)).getAmount(), 0L);
                didTransfer = true;
                if (chemicalTank.getNeeded() == 0L) break;
            }
            if (didTransfer) {
                slot.onContentsChanged();
                return true;
            }
        }
        return false;
    }

    public void drainTank() {
        ChemicalInventorySlot.drainChemicalTank(this, this.chemicalTank, this.getCapability());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void drainChemicalTank(IInventorySlot slot, IChemicalTank<CHEMICAL, STACK> chemicalTank, @Nullable IChemicalHandler<CHEMICAL, STACK> handler) {
        STACK extractedChemical;
        long amount;
        STACK storedChemical;
        STACK simulatedRemainder;
        long remainder;
        if (!(slot.isEmpty() || chemicalTank.isEmpty() || handler == null || (remainder = ((ChemicalStack)(simulatedRemainder = handler.insertChemical(storedChemical = chemicalTank.getStack(), Action.SIMULATE))).getAmount()) >= (amount = ((ChemicalStack)storedChemical).getAmount()) || ((ChemicalStack)(extractedChemical = chemicalTank.extract(amount - remainder, Action.EXECUTE, AutomationType.INTERNAL))).isEmpty())) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)handler.insertChemical(extractedChemical, Action.EXECUTE)).getAmount(), 0L);
            slot.onContentsChanged();
        }
    }
}

