/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.type;

import mekanism.common.inventory.container.type.BaseMekanismContainerType;
import mekanism.common.util.RegistryUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekanismItemContainerType<ITEM extends Item, CONTAINER extends AbstractContainerMenu>
extends BaseMekanismContainerType<ITEM, CONTAINER, IMekanismItemContainerFactory<ITEM, CONTAINER>> {
    public static <ITEM extends Item, CONTAINER extends AbstractContainerMenu> MekanismItemContainerType<ITEM, CONTAINER> item(Class<ITEM> type, IMekanismItemContainerFactory<ITEM, CONTAINER> constructor) {
        return new MekanismItemContainerType<ITEM, CONTAINER>(type, constructor, (id, inv, buf) -> constructor.create(id, inv, (InteractionHand)buf.m_130066_(InteractionHand.class), MekanismItemContainerType.getStackFromBuffer(buf, type)));
    }

    public static <ITEM extends Item, CONTAINER extends AbstractContainerMenu> MekanismItemContainerType<ITEM, CONTAINER> item(Class<ITEM> type, IMekanismSidedItemContainerFactory<ITEM, CONTAINER> constructor) {
        return new MekanismItemContainerType<ITEM, CONTAINER>(type, constructor, (id, inv, buf) -> constructor.create(id, inv, (InteractionHand)buf.m_130066_(InteractionHand.class), MekanismItemContainerType.getStackFromBuffer(buf, type), true));
    }

    protected MekanismItemContainerType(Class<ITEM> type, IMekanismItemContainerFactory<ITEM, CONTAINER> mekanismConstructor, IContainerFactory<CONTAINER> constructor) {
        super(type, mekanismConstructor, constructor);
    }

    @Nullable
    public CONTAINER create(int id, Inventory inv, InteractionHand hand, ItemStack stack) {
        if (!stack.m_41619_() && this.type.isInstance(stack.m_41720_())) {
            return ((IMekanismItemContainerFactory)this.mekanismConstructor).create(id, inv, hand, stack);
        }
        return null;
    }

    @Nullable
    public MenuConstructor create(InteractionHand hand, ItemStack stack) {
        if (!stack.m_41619_() && this.type.isInstance(stack.m_41720_())) {
            return (id, inv, player) -> ((IMekanismItemContainerFactory)this.mekanismConstructor).create(id, inv, hand, stack);
        }
        return null;
    }

    @NotNull
    private static <ITEM extends Item> ItemStack getStackFromBuffer(FriendlyByteBuf buf, Class<ITEM> type) {
        if (buf == null) {
            throw new IllegalArgumentException("Null packet buffer");
        }
        ItemStack stack = buf.m_130267_();
        if (type.isInstance(stack.m_41720_())) {
            return stack;
        }
        throw new IllegalStateException("Client received invalid stack (" + RegistryUtils.getName(stack.m_41720_()) + ") for item container.");
    }

    @FunctionalInterface
    public static interface IMekanismItemContainerFactory<ITEM extends Item, CONTAINER extends AbstractContainerMenu> {
        public CONTAINER create(int var1, Inventory var2, InteractionHand var3, ItemStack var4);
    }

    @FunctionalInterface
    public static interface IMekanismSidedItemContainerFactory<ITEM extends Item, CONTAINER extends AbstractContainerMenu>
    extends IMekanismItemContainerFactory<ITEM, CONTAINER> {
        public CONTAINER create(int var1, Inventory var2, InteractionHand var3, ItemStack var4, boolean var5);

        @Override
        default public CONTAINER create(int id, Inventory inv, InteractionHand hand, ItemStack stack) {
            return this.create(id, inv, hand, stack, false);
        }
    }
}

