/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.IntPropertyData;

public abstract class SyncableInt
implements ISyncableData {
    private int lastKnownValue;

    public abstract int get();

    public abstract void set(int var1);

    @Override
    public ISyncableData.DirtyType isDirty() {
        int oldValue = this.get();
        boolean dirty = oldValue != this.lastKnownValue;
        this.lastKnownValue = oldValue;
        return ISyncableData.DirtyType.get(dirty);
    }

    @Override
    public IntPropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        return new IntPropertyData(property, this.get());
    }

    public static SyncableInt create(final int[] intArray, final int idx) {
        return new SyncableInt(){

            @Override
            public int get() {
                return intArray[idx];
            }

            @Override
            public void set(int value) {
                intArray[idx] = value;
            }
        };
    }

    public static SyncableInt create(final IntSupplier getter, final IntConsumer setter) {
        return new SyncableInt(){

            @Override
            public int get() {
                return getter.getAsInt();
            }

            @Override
            public void set(int value) {
                setter.accept(value);
            }
        };
    }
}

