/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.Objects;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class SorterItemStackFilter
extends SorterFilter<SorterItemStackFilter>
implements IItemStackFilter<SorterItemStackFilter> {
    private ItemStack itemType = ItemStack.f_41583_;
    public boolean fuzzyMode;

    public SorterItemStackFilter() {
    }

    public SorterItemStackFilter(SorterItemStackFilter filter) {
        super(filter);
        this.itemType = filter.itemType.m_41777_();
        this.fuzzyMode = filter.fuzzyMode;
    }

    @Override
    public Finder getFinder() {
        return this.fuzzyMode ? Finder.item(this.itemType) : Finder.strict(this.itemType);
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.m_128379_("fuzzyMode", this.fuzzyMode);
        this.itemType.m_41739_(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        NBTUtils.setBooleanIfPresent(nbtTags, "fuzzyMode", fuzzy -> {
            this.fuzzyMode = fuzzy;
        });
        this.itemType = ItemStack.m_41712_((CompoundTag)nbtTags);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.fuzzyMode);
        buffer.m_130055_(this.itemType);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.fuzzyMode = dataStream.readBoolean();
        this.itemType = dataStream.m_130267_();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.itemType.m_41720_(), this.fuzzyMode);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SorterItemStackFilter other = (SorterItemStackFilter)o;
        if (this.fuzzyMode == other.fuzzyMode) {
            if (this.fuzzyMode) {
                return this.itemType.m_41656_(other.itemType);
            }
            return ItemHandlerHelper.canItemStacksStack((ItemStack)this.itemType, (ItemStack)other.itemType);
        }
        return false;
    }

    @Override
    public SorterItemStackFilter clone() {
        return new SorterItemStackFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SORTER_ITEMSTACK_FILTER;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@NotNull ItemStack stack) {
        this.itemType = stack;
    }
}

