/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.client.render.armor.ICustomArmor;
import mekanism.client.render.armor.ISpecialGear;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

@ParametersAreNotNullByDefault
public class MekanismArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    public MekanismArmorLayer(RenderLayerParent<T, M> entityRenderer, A modelLeggings, A modelArmor) {
        super(entityRenderer, modelLeggings, modelArmor);
    }

    public void m_6494_(PoseStack matrix, MultiBufferSource renderer, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderArmorPart(matrix, renderer, entity, EquipmentSlot.CHEST, packedLightIn, partialTicks);
        this.renderArmorPart(matrix, renderer, entity, EquipmentSlot.LEGS, packedLightIn, partialTicks);
        this.renderArmorPart(matrix, renderer, entity, EquipmentSlot.FEET, packedLightIn, partialTicks);
        this.renderArmorPart(matrix, renderer, entity, EquipmentSlot.HEAD, packedLightIn, partialTicks);
    }

    private void renderArmorPart(PoseStack matrix, MultiBufferSource renderer, T entity, EquipmentSlot slot, int light, float partialTicks) {
        IClientItemExtensions iClientItemExtensions;
        ArmorItem armorItem;
        ItemStack stack = entity.m_6844_(slot);
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == slot && (iClientItemExtensions = IClientItemExtensions.of((Item)item)) instanceof ISpecialGear) {
            ISpecialGear specialGear = (ISpecialGear)iClientItemExtensions;
            ICustomArmor model = specialGear.getGearModel(slot);
            HumanoidModel coreModel = slot == EquipmentSlot.LEGS ? this.f_117071_ : this.f_117072_;
            ((HumanoidModel)this.m_117386_()).m_102872_(coreModel);
            this.m_117125_(coreModel, slot);
            model.render((HumanoidModel<? extends LivingEntity>)coreModel, matrix, renderer, light, OverlayTexture.f_118083_, partialTicks, stack.m_41790_(), (LivingEntity)entity, stack);
        }
    }
}

