/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiQIOFrequencyTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.qio.GuiQIOFilterHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.qio.IQIOFrequencyHolder;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.util.StackUtils;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiQIORedstoneAdapter
extends GuiMekanismTile<TileEntityQIORedstoneAdapter, MekanismTileContainer<TileEntityQIORedstoneAdapter>> {
    private GuiTextField text;

    public GuiQIORedstoneAdapter(MekanismTileContainer<TileEntityQIORedstoneAdapter> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.f_97727_ += 26;
        this.f_97731_ = this.f_97727_ - 94;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiQIOFrequencyTab((IGuiWrapper)this, this.tile));
        this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, 7, 30).setRenderHover(true)).click((element, mouseX, mouseY) -> {
            ItemStack stack = this.getCarriedItem();
            if (stack.m_41619_() == GuiQIORedstoneAdapter.m_96638_()) {
                this.updateStack(stack);
                return true;
            }
            return false;
        }, (SoundEvent)MekanismSounds.BEEP.get()).setGhostHandler(ingredient -> {
            this.updateStack((ItemStack)ingredient);
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
        });
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 9, 80, 14, this.getButtonLocation("fuzzy"), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.QIO_REDSTONE_ADAPTER_FUZZY, this.tile)), this.getOnHover(MekanismLang.FUZZY_MODE)));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 7, 16, this.f_97726_ - 15, 12, GuiQIOFilterHandler.getFrequencyText((IQIOFrequencyHolder)((Object)this.tile))).tooltip(GuiQIOFilterHandler.getFrequencyTooltip((IQIOFrequencyHolder)((Object)this.tile))));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 27, 30, this.f_97726_ - 27 - 8, 64, () -> {
            ArrayList<Object> list = new ArrayList<Object>();
            ItemStack itemType = ((TileEntityQIORedstoneAdapter)this.tile).getItemType();
            list.add(itemType.m_41619_() ? MekanismLang.QIO_ITEM_TYPE_UNDEFINED.translate(new Object[0]) : itemType.m_41786_());
            list.add(MekanismLang.QIO_TRIGGER_COUNT.translate(TextUtils.format(((TileEntityQIORedstoneAdapter)this.tile).getCount())));
            if (!itemType.m_41619_() && ((TileEntityQIORedstoneAdapter)this.tile).getQIOFrequency() != null) {
                list.add(MekanismLang.QIO_STORED_COUNT.translate(TextUtils.format(((TileEntityQIORedstoneAdapter)this.tile).getStoredCount())));
            }
            list.add(MekanismLang.QIO_FUZZY_MODE.translate(((TileEntityQIORedstoneAdapter)this.tile).getFuzzyMode()));
            return list;
        }).clearFormat());
        this.text = this.addRenderableWidget(new GuiTextField(this, 29, 80, this.f_97726_ - 39, 12));
        this.text.setMaxLength(10);
        this.text.setInputValidator(InputValidator.DIGIT);
        this.text.m_93692_(true);
        this.text.configureDigitalInput(this::setCount);
    }

    private void updateStack(ItemStack stack) {
        Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.QIO_REDSTONE_ADAPTER_STACK, (BlockEntity)this.tile, StackUtils.size(stack, 1)));
    }

    private void setCount() {
        if (!this.text.getText().isEmpty()) {
            long count = Long.parseLong(this.text.getText());
            Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.QIO_REDSTONE_ADAPTER_COUNT, (BlockEntity)this.tile, (int)Math.min(count, Integer.MAX_VALUE)));
            this.text.setText("");
        }
    }

    @Override
    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        this.renderItem(matrix, ((TileEntityQIORedstoneAdapter)this.tile).getItemType(), 8, 31);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

