/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.gauge.GaugeInfo;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.warning.ISupportsWarning;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiGauge<T>
extends GuiTexturedElement
implements ISupportsWarning<GuiGauge<T>> {
    private final GaugeType gaugeType;
    protected boolean dummy;
    protected T dummyType;
    @Nullable
    private BooleanSupplier warningSupplier;

    public GuiGauge(GaugeType gaugeType, IGuiWrapper gui, int x, int y) {
        this(gaugeType, gui, x, y, gaugeType.getGaugeOverlay().getWidth() + 2, gaugeType.getGaugeOverlay().getHeight() + 2);
    }

    public GuiGauge(GaugeType gaugeType, IGuiWrapper gui, int x, int y, int sizeX, int sizeY) {
        super(gaugeType.getGaugeOverlay().getBarOverlay(), gui, x, y, sizeX, sizeY);
        this.gaugeType = gaugeType;
    }

    @Override
    public GuiGauge<T> warning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        this.warningSupplier = ISupportsWarning.compound(this.warningSupplier, this.gui().trackWarning(type, warningSupplier));
        return this;
    }

    public abstract int getScaledLevel();

    public abstract TextureAtlasSprite getIcon();

    public abstract Component getLabel();

    public abstract List<Component> getTooltipText();

    public GaugeOverlay getGaugeOverlay() {
        return this.gaugeType.getGaugeOverlay();
    }

    protected GaugeInfo getGaugeColor() {
        return this.gaugeType.getGaugeInfo();
    }

    protected void applyRenderColor() {
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        GaugeInfo color = this.getGaugeColor();
        this.renderExtendedTexture(matrix, color.getResourceLocation(), color.getSideWidth(), color.getSideHeight());
        if (!this.dummy) {
            this.renderContents(matrix);
        }
    }

    public void renderContents(PoseStack matrix) {
        boolean warning;
        boolean bl = warning = this.warningSupplier != null && this.warningSupplier.getAsBoolean();
        if (warning) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiSlot.WARNING_BACKGROUND_TEXTURE);
            GuiGauge.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (float)0.0f, (float)0.0f, (int)(this.f_93618_ - 2), (int)(this.f_93619_ - 2), (int)256, (int)256);
        }
        int scale = this.getScaledLevel();
        TextureAtlasSprite icon = this.getIcon();
        if (scale > 0 && icon != null) {
            this.applyRenderColor();
            this.drawTiledSprite(matrix, this.f_93620_ + 1, this.f_93621_ + 1, this.f_93619_ - 2, this.f_93618_ - 2, scale, icon, GuiUtils.TilingDirection.UP_RIGHT);
            MekanismRenderer.resetColor();
            if (warning && (double)scale / (double)(this.f_93619_ - 2) > 0.98) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)WARNING_TEXTURE);
                int halfWidth = (this.f_93618_ - 2) / 2;
                GuiGauge.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + 1 + halfWidth), (int)(this.f_93621_ + 1), (float)halfWidth, (float)0.0f, (int)halfWidth, (int)(this.f_93619_ - 2), (int)256, (int)256);
            }
        }
        this.drawBarOverlay(matrix);
    }

    public void drawBarOverlay(PoseStack matrix) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        GaugeOverlay gaugeOverlay = this.getGaugeOverlay();
        GuiGauge.m_93160_((PoseStack)matrix, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (int)(this.m_5711_() - 2), (int)(this.m_93694_() - 2), (float)0.0f, (float)0.0f, (int)gaugeOverlay.getWidth(), (int)gaugeOverlay.getHeight(), (int)gaugeOverlay.getWidth(), (int)gaugeOverlay.getHeight());
    }

    @Override
    public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        ItemStack stack = this.gui().getCarriedItem();
        EnumColor color = this.getGaugeColor().getColor();
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemConfigurator && color != null) {
            GuiMekanismTile gui;
            IGuiWrapper iGuiWrapper = this.gui();
            if (iGuiWrapper instanceof GuiMekanismTile && (iGuiWrapper = (gui = (GuiMekanismTile)iGuiWrapper).getTileEntity()) instanceof ISideConfiguration) {
                ISideConfiguration sideConfig = (ISideConfiguration)((Object)iGuiWrapper);
                if (this.getTransmission() != null) {
                    DataType dataType = null;
                    ConfigInfo config = sideConfig.getConfig().getConfig(this.getTransmission());
                    if (config != null) {
                        Set<DataType> supportedDataTypes = config.getSupportedDataTypes();
                        for (DataType type : supportedDataTypes) {
                            if (type.getColor() != color) continue;
                            dataType = type;
                            break;
                        }
                    }
                    if (dataType == null) {
                        this.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.GENERIC_PARENTHESIS.translateColored(color, color.getName())});
                    } else {
                        this.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(color, dataType, color.getName())});
                    }
                }
            }
        } else {
            ArrayList<Component> list = new ArrayList<Component>();
            if (this.getLabel() != null) {
                list.add(this.getLabel());
            }
            list.addAll(this.getTooltipText());
            this.displayTooltips(matrix, mouseX, mouseY, list);
        }
    }

    @Nullable
    public abstract TransmissionType getTransmission();

    public void setDummyType(T type) {
        this.dummyType = type;
    }
}

