/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public class ChemicalBuilder<CHEMICAL extends Chemical<CHEMICAL>, BUILDER extends ChemicalBuilder<CHEMICAL, BUILDER>> {
    private final Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> attributeMap = new Object2ObjectOpenHashMap();
    private final ResourceLocation texture;
    private int color = 0xFFFFFF;
    private boolean hidden;

    protected ChemicalBuilder(ResourceLocation texture) {
        this.texture = texture;
    }

    public BUILDER with(ChemicalAttribute attribute) {
        this.attributeMap.put(attribute.getClass(), attribute);
        return this.getThis();
    }

    public Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> getAttributeMap() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public BUILDER color(int color) {
        this.color = color;
        return this.getThis();
    }

    public BUILDER hidden() {
        this.hidden = true;
        return this.getThis();
    }

    public int getColor() {
        return this.color;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    protected BUILDER getThis() {
        return (BUILDER)this;
    }
}

