/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.tools;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class RedstoneChannels
extends AbstractWorldData<RedstoneChannels> {
    private static final String REDSTONE_CHANNELS_NAME = "RfToolsRedstoneChannels";
    private int lastId = 0;
    private final Map<Integer, RedstoneChannel> channels = new HashMap<Integer, RedstoneChannel>();

    public static RedstoneChannels getChannels(Level world) {
        return (RedstoneChannels)RedstoneChannels.getData((Level)world, RedstoneChannels::new, RedstoneChannels::new, (String)REDSTONE_CHANNELS_NAME);
    }

    public RedstoneChannels() {
    }

    public RedstoneChannels(CompoundTag tagCompound) {
        ListTag lst = tagCompound.m_128437_("channels", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundTag tc = lst.m_128728_(i);
            int channel = tc.m_128451_("channel");
            int v = tc.m_128451_("value");
            String name = tc.m_128461_("name");
            RedstoneChannel value = new RedstoneChannel();
            value.value = v;
            value.setName(name);
            this.channels.put(channel, value);
        }
        this.lastId = tagCompound.m_128451_("lastId");
    }

    public RedstoneChannel getOrCreateChannel(int id) {
        RedstoneChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new RedstoneChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public RedstoneChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tagCompound) {
        ListTag lst = new ListTag();
        for (Map.Entry<Integer, RedstoneChannel> entry : this.channels.entrySet()) {
            CompoundTag tc = new CompoundTag();
            tc.m_128405_("channel", entry.getKey().intValue());
            tc.m_128405_("value", entry.getValue().getValue());
            tc.m_128359_("name", entry.getValue().getName());
            lst.add((Object)tc);
        }
        tagCompound.m_128365_("channels", (Tag)lst);
        tagCompound.m_128405_("lastId", this.lastId);
        return tagCompound;
    }

    public static class RedstoneChannel {
        private int value = 0;
        private String name = "";

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

