/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;

public class WeightedRandom<T> {
    private static final Random random = new Random();
    public List<Pair<T, Float>> weightedList = new ArrayList<Pair<T, Float>>();
    private boolean sorted = false;
    private float maximum = 0.0f;

    public void add(T element, float weight) {
        this.weightedList.add(Pair.of(element, (Object)Float.valueOf(weight)));
        this.sorted = false;
        this.maximum = 0.0f;
    }

    public T getRandom() {
        if (!this.sorted) {
            this.weightedList.sort((p1, p2) -> -((Float)p1.getRight()).compareTo((Float)p2.getRight()));
            this.sorted = true;
            this.maximum = 0.0f;
            for (Pair<T, Float> pair : this.weightedList) {
                this.maximum += ((Float)pair.getRight()).floatValue();
            }
        }
        float v = random.nextFloat() * this.maximum;
        for (Pair<T, Float> pair : this.weightedList) {
            if (v <= ((Float)pair.getRight()).floatValue()) {
                return (T)pair.getKey();
            }
            v -= ((Float)pair.getRight()).floatValue();
        }
        return (T)this.weightedList.get(0).getKey();
    }
}

