/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.datagen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.crafting.CopyNBTRecipeBuilder;
import mcjty.lib.crafting.IRecipeBuilder;
import mcjty.lib.datagen.BaseBlockStateProvider;
import mcjty.lib.datagen.BaseItemModelProvider;
import mcjty.lib.datagen.BaseLootTableProvider;
import mcjty.lib.datagen.IRecipeFactory;
import mcjty.lib.datagen.ITagFactory;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.RegistryObject;

public record Dob(Supplier<? extends Block> blockSupplier, Supplier<? extends Item> itemSupplier, Supplier<? extends EntityType> entitySupplier, Map<String, Supplier<Map<ResourceLocation, Object>>> codecObjectSupplier, Map<String, Supplier<IGlobalLootModifier>> glmSupplier, String translatedName, Map<String, String> keyedMessages, Map<String, String> messages, Consumer<BaseLootTableProvider> loot, Consumer<BaseBlockStateProvider> blockstate, Consumer<BaseItemModelProvider> item, Consumer<ITagFactory> blockTags, Consumer<ITagFactory> itemTags, Consumer<IRecipeFactory> recipe) {
    public static Builder builder() {
        return new Builder(null, null, null);
    }

    public static Builder builder(Supplier<? extends Block> blockSupplier, Supplier<? extends Item> itemSupplier) {
        return new Builder(blockSupplier, itemSupplier, null);
    }

    public static Builder blockBuilder(Supplier<? extends Block> blockSupplier) {
        return new Builder(blockSupplier, null, null);
    }

    public static Builder itemBuilder(Supplier<? extends Item> itemSupplier) {
        return new Builder(null, itemSupplier, null);
    }

    public static Builder entityBuilder(Supplier<? extends EntityType> entitySupplier) {
        return new Builder(null, null, entitySupplier);
    }

    public static class Builder {
        private final Supplier<? extends Block> blockSupplier;
        private final Supplier<? extends Item> itemSupplier;
        private final Supplier<? extends EntityType> entitySupplier;
        private final Map<String, Supplier<Map<ResourceLocation, Object>>> codecObjectSupplier = new HashMap<String, Supplier<Map<ResourceLocation, Object>>>();
        private final Map<String, Supplier<IGlobalLootModifier>> glmSupplier = new HashMap<String, Supplier<IGlobalLootModifier>>();
        private String translatedName = null;
        private Map<String, String> keyedMessages = new HashMap<String, String>();
        private Map<String, String> messages = new HashMap<String, String>();
        private Consumer<BaseLootTableProvider> loot = p -> {};
        private Consumer<BaseBlockStateProvider> blockstate = p -> {};
        private Consumer<BaseItemModelProvider> item = p -> {};
        private Consumer<ITagFactory> blockTags = f -> {};
        private Consumer<ITagFactory> itemTags = f -> {};
        private Consumer<IRecipeFactory> recipe = f -> {};

        public Builder(Supplier<? extends Block> blockSupplier, Supplier<? extends Item> itemSupplier, Supplier<? extends EntityType> entitySupplier) {
            this.blockSupplier = blockSupplier;
            this.itemSupplier = itemSupplier;
            this.entitySupplier = entitySupplier;
        }

        public Builder codecObjectSupplier(String name, Supplier<Map<ResourceLocation, Object>> supplier) {
            Supplier<Map<ResourceLocation, Object>> oldSupplier = this.codecObjectSupplier.get(name);
            if (oldSupplier == null) {
                this.codecObjectSupplier.put(name, supplier);
            } else {
                this.codecObjectSupplier.put(name, () -> {
                    HashMap old = new HashMap((Map)oldSupplier.get());
                    old.putAll((Map)supplier.get());
                    return old;
                });
            }
            return this;
        }

        public Builder glm(String lootName, Supplier<IGlobalLootModifier> modifier) {
            this.glmSupplier.put(lootName, modifier);
            return this;
        }

        public Builder name(String name) {
            this.translatedName = name;
            return this;
        }

        public Builder keyedMessage(String key, String message) {
            this.keyedMessages.put(key, message);
            return this;
        }

        public Builder message(String key, String message) {
            this.messages.put(key, message);
            return this;
        }

        public Builder loot(Consumer<BaseLootTableProvider> loot) {
            this.loot = loot;
            return this;
        }

        public Builder simpleLoot() {
            this.loot = p -> p.addSimpleTable(this.blockSupplier.get());
            return this;
        }

        public Builder standardLoot(RegistryObject be) {
            this.loot = f -> f.addStandardTable(this.blockSupplier.get(), (BlockEntityType)be.get());
            return this;
        }

        public Builder silkTouchLoot(Supplier<Item> lootItem, float min, float max) {
            this.loot = f -> f.addLootTable(this.blockSupplier.get(), f.createSilkTouchTable("silk", this.blockSupplier.get(), (Item)lootItem.get(), min, max));
            return this;
        }

        public Builder blockState(Consumer<BaseBlockStateProvider> factory) {
            this.blockstate = factory;
            return this;
        }

        public Builder simpleBlockState() {
            this.blockstate = provider -> provider.simpleBlock(this.blockSupplier.get());
            return this;
        }

        public Builder itemModel(Consumer<BaseItemModelProvider> factory) {
            this.item = factory;
            return this;
        }

        public Builder handheldItem(String texture) {
            this.item = f -> f.itemHandheld(this.itemSupplier.get(), texture);
            return this;
        }

        public Builder generatedItem(String texture) {
            this.item = f -> f.itemGenerated(this.itemSupplier.get(), texture);
            return this;
        }

        public Builder cubeAll(ResourceLocation texture) {
            this.item = f -> f.cubeAll(f.name(this.itemSupplier.get()), texture);
            return this;
        }

        public Builder parentedItem(String model) {
            this.item = f -> f.parentedBlock(this.blockSupplier.get(), model);
            return this;
        }

        public Builder parentedItem() {
            this.item = f -> f.parentedBlock(this.blockSupplier.get());
            return this;
        }

        public Builder stonePickaxeTags() {
            Consumer<ITagFactory> orig = this.blockTags;
            this.blockTags = f -> {
                orig.accept((ITagFactory)f);
                f.blockTags(this.blockSupplier, List.of(BlockTags.f_144282_, BlockTags.f_144286_));
            };
            return this;
        }

        public Builder ironPickaxeTags() {
            Consumer<ITagFactory> orig = this.blockTags;
            this.blockTags = f -> {
                orig.accept((ITagFactory)f);
                f.blockTags(this.blockSupplier, List.of(BlockTags.f_144282_, BlockTags.f_144285_));
            };
            return this;
        }

        public Builder diamondPickaxeTags() {
            Consumer<ITagFactory> orig = this.blockTags;
            this.blockTags = f -> {
                orig.accept((ITagFactory)f);
                f.blockTags(this.blockSupplier, List.of(BlockTags.f_144282_, BlockTags.f_144284_));
            };
            return this;
        }

        public Builder blockTags(List<TagKey> tags) {
            Consumer<ITagFactory> orig = this.blockTags;
            this.blockTags = f -> {
                orig.accept((ITagFactory)f);
                f.blockTags(this.blockSupplier, tags);
            };
            return this;
        }

        public Builder itemTags(List<TagKey> tags) {
            Consumer<ITagFactory> orig = this.itemTags;
            this.itemTags = f -> {
                orig.accept((ITagFactory)f);
                f.itemTags(this.itemSupplier, tags);
            };
            return this;
        }

        private ItemLike getItemLike() {
            if (this.blockSupplier == null) {
                return (ItemLike)this.itemSupplier.get();
            }
            return (ItemLike)this.blockSupplier.get();
        }

        public Builder recipeConsumer(Supplier<Consumer<Consumer<FinishedRecipe>>> consumerSupplier) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.recipeConsumer(consumerSupplier);
            };
            return this;
        }

        public Builder recipe(Supplier<IRecipeBuilder> recipe) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.recipe(recipe);
            };
            return this;
        }

        public Builder recipe(String id, Supplier<IRecipeBuilder> recipe) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.recipe(id, recipe);
            };
            return this;
        }

        public Builder shapedNBT(Function<CopyNBTRecipeBuilder, CopyNBTRecipeBuilder> builder, String ... pattern) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.shapedNBT((CopyNBTRecipeBuilder)builder.apply(CopyNBTRecipeBuilder.shapedRecipe(this.getItemLike())), pattern);
            };
            return this;
        }

        public Builder shapedNBT(String id, Function<CopyNBTRecipeBuilder, CopyNBTRecipeBuilder> builder, String ... pattern) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.shapedNBT(id, (CopyNBTRecipeBuilder)builder.apply(CopyNBTRecipeBuilder.shapedRecipe(this.getItemLike())), pattern);
            };
            return this;
        }

        public Builder shaped(Function<ShapedRecipeBuilder, ShapedRecipeBuilder> builder, String ... pattern) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.shaped((ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_126116_((ItemLike)this.getItemLike())), pattern);
            };
            return this;
        }

        public Builder shaped(Function<ShapedRecipeBuilder, ShapedRecipeBuilder> builder, int amount, String ... pattern) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.shaped((ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_126118_((ItemLike)this.getItemLike(), (int)amount)), pattern);
            };
            return this;
        }

        public Builder shaped(String id, Function<ShapedRecipeBuilder, ShapedRecipeBuilder> builder, String ... pattern) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.shaped(id, (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_126116_((ItemLike)this.getItemLike())), pattern);
            };
            return this;
        }

        public Builder shaped(String id, Function<ShapedRecipeBuilder, ShapedRecipeBuilder> builder, int amount, String ... pattern) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.shaped(id, (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_126118_((ItemLike)this.getItemLike(), (int)amount)), pattern);
            };
            return this;
        }

        public Builder shapeless(Function<ShapelessRecipeBuilder, ShapelessRecipeBuilder> builder) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.shapeless((ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_126189_((ItemLike)this.getItemLike())));
            };
            return this;
        }

        public Builder shapeless(String id, Function<ShapelessRecipeBuilder, ShapelessRecipeBuilder> builder) {
            Consumer<IRecipeFactory> orig = this.recipe;
            this.recipe = f -> {
                orig.accept((IRecipeFactory)f);
                f.shapeless(id, (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_126189_((ItemLike)this.getItemLike())));
            };
            return this;
        }

        public Dob build() {
            return new Dob(this.blockSupplier, this.itemSupplier, this.entitySupplier, new HashMap<String, Supplier<Map<ResourceLocation, Object>>>(this.codecObjectSupplier), new HashMap<String, Supplier<IGlobalLootModifier>>(this.glmSupplier), this.translatedName, new HashMap<String, String>(this.keyedMessages), new HashMap<String, String>(this.messages), this.loot, this.blockstate, this.item, this.blockTags, this.itemTags, this.recipe);
        }
    }
}

