/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElementMasterSubGui;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElementRecipeSubGui;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket;

public class ValueTypeRecipeLPElement
extends ValueTypeLPElementBase {
    public static final int SLOT_OFFSET = 4;
    public static final int TICK_DELAY = 30;
    @OnlyIn(value=Dist.CLIENT)
    public ValueTypeRecipeLPElementMasterSubGui lastGui;
    private NonNullList<ItemMatchProperties> inputStacks;
    private ItemStack inputFluid;
    private String inputFluidAmount = "0";
    private String inputEnergy = "0";
    private NonNullList<ItemStack> outputStacks;
    private ItemStack outputFluid;
    private String outputFluidAmount = "0";
    private String outputEnergy = "0";

    public ValueTypeRecipeLPElement() {
        super(ValueTypes.OBJECT_RECIPE);
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.RECIPE;
    }

    @Override
    public void onInputSlotUpdated(int slotId, ItemStack itemStack) {
        ItemStack itemStackOld;
        if (this.inputStacks == null) {
            return;
        }
        if (slotId >= 0 && slotId < 9 && (itemStackOld = ((ItemMatchProperties)this.inputStacks.get(slotId)).getItemStack()).m_41720_() != itemStack.m_41720_()) {
            this.inputStacks.set(slotId, (Object)new ItemMatchProperties(itemStack.m_41777_()));
            if (MinecraftHelpers.isClientSideThread()) {
                this.refreshPropertiesGui(slotId);
            }
        }
        if (slotId == 9) {
            this.inputFluid = itemStack.m_41777_();
            if (this.inputFluidAmount.equalsIgnoreCase("0")) {
                int amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack(this.inputFluid));
                this.inputFluidAmount = Integer.toString(amount);
                if (MinecraftHelpers.isClientSideThread() && this.lastGui != null) {
                    this.refreshInputFluidAmountBox();
                }
            }
        }
        if (slotId > 9 && slotId < 13) {
            this.outputStacks.set(slotId - 10, (Object)itemStack.m_41777_());
        }
        if (slotId == 13) {
            this.outputFluid = itemStack.m_41777_();
            if (this.outputFluidAmount.equalsIgnoreCase("0")) {
                int amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack(this.outputFluid));
                this.outputFluidAmount = Integer.toString(amount);
                if (MinecraftHelpers.isClientSideThread() && this.lastGui != null) {
                    this.refreshOutputFluidAmountBox();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshPropertiesGui(int slot) {
        if (this.lastGui != null && this.lastGui.isPropertySubGuiActive(slot)) {
            this.lastGui.propertiesSubGuis.get(slot).loadStateToGui();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshInputFluidAmountBox() {
        if (this.lastGui != null && this.lastGui.subGuiRecipe.getInputFluidAmountBox() != null) {
            this.lastGui.subGuiRecipe.getInputFluidAmountBox().m_94144_(this.inputFluidAmount);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshOutputFluidAmountBox() {
        if (this.lastGui != null && this.lastGui.subGuiRecipe.getOutputFluidAmountBox() != null) {
            this.lastGui.subGuiRecipe.getOutputFluidAmountBox().m_94144_(this.outputFluidAmount);
        }
    }

    public void sendSlotPropertiesToServer(int slotId, ItemMatchProperties props) {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeSlotPropertiesChangedPacket(slotId, props.isNbt(), props.getItemTag() == null ? "" : props.getItemTag(), props.getTagQuantity(), props.isReusable()));
    }

    public boolean isValidForRecipeGrid(List<ItemMatchProperties> itemInputs, List<FluidStack> fluidInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs) {
        return itemInputs.size() <= 9 && itemOutputs.size() <= 3 && fluidInputs.size() <= 1 && fluidOutputs.size() <= 1;
    }

    protected void putItemPropertiesInContainer(ContainerLogicProgrammerBase container, int slot, ItemMatchProperties props) {
        this.putStackInContainer(container, slot, props.getItemStack());
        this.getInputStacks().set(slot, (Object)props);
    }

    protected void putStackInContainer(ContainerLogicProgrammerBase container, int slot, ItemStack itemStack) {
        container.m_182406_(container.m_38927_().size() - 50 + slot, 0, itemStack);
    }

    /*
     * WARNING - void declaration
     */
    public void setRecipeGrid(ContainerLogicProgrammerBase container, List<ItemMatchProperties> itemInputs, List<FluidStack> fluidInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs) {
        void var8_12;
        int slot = 0;
        for (ItemMatchProperties itemMatchProperties : itemInputs) {
            this.putItemPropertiesInContainer(container, slot, itemMatchProperties);
            ++slot;
        }
        while (slot < 9) {
            this.putItemPropertiesInContainer(container, slot, new ItemMatchProperties(ItemStack.f_41583_));
            ++slot;
        }
        slot = 9;
        FluidStack fluidStackInput = FluidStack.EMPTY;
        if (fluidInputs.size() > 0) {
            fluidStackInput = fluidInputs.get(0);
        }
        this.putStackInContainer(container, slot, fluidStackInput.isEmpty() ? ItemStack.f_41583_ : this.getFluidBucket(fluidStackInput));
        this.inputFluidAmount = String.valueOf(FluidHelpers.getAmount((FluidStack)fluidStackInput));
        if (MinecraftHelpers.isClientSideThread()) {
            this.refreshInputFluidAmountBox();
        }
        slot = 10;
        for (ItemStack itemOutput : itemOutputs) {
            this.putStackInContainer(container, slot, itemOutput);
            ++slot;
        }
        while (slot < 13) {
            this.putStackInContainer(container, slot, ItemStack.f_41583_);
            ++slot;
        }
        slot = 13;
        FluidStack fluidStack = FluidStack.EMPTY;
        if (fluidOutputs.size() > 0) {
            FluidStack fluidStack2 = fluidOutputs.get(0);
        }
        this.putStackInContainer(container, slot, var8_12.isEmpty() ? ItemStack.f_41583_ : this.getFluidBucket((FluidStack)var8_12));
        this.outputFluidAmount = String.valueOf(FluidHelpers.getAmount((FluidStack)var8_12));
        if (MinecraftHelpers.isClientSideThread()) {
            this.refreshOutputFluidAmountBox();
        }
    }

    protected ItemStack getFluidBucket(FluidStack fluidStack) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42446_);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        fluidHandler.fill(new FluidStack(fluidStack, 1000), IFluidHandler.FluidAction.EXECUTE);
        return fluidHandler.getContainer();
    }

    protected boolean isInputValid() {
        return this.inputStacks.stream().anyMatch(ItemMatchProperties::isValid) || !this.inputFluid.m_41619_() || !this.inputFluidAmount.equalsIgnoreCase("0") || !this.inputEnergy.equalsIgnoreCase("0");
    }

    protected boolean isOutputValid() {
        return this.outputStacks.stream().anyMatch(stack -> !stack.m_41619_()) || !this.outputFluid.m_41619_() || !this.outputFluidAmount.equalsIgnoreCase("0") || !this.outputEnergy.equalsIgnoreCase("0");
    }

    @Override
    public boolean canWriteElementPre() {
        return this.isInputValid() == this.isOutputValid();
    }

    @Override
    public void activate() {
        this.inputStacks = NonNullList.m_122780_((int)9, (Object)new ItemMatchProperties(ItemStack.f_41583_));
        for (int i = 0; i < 9; ++i) {
            this.inputStacks.set(i, (Object)new ItemMatchProperties(ItemStack.f_41583_));
        }
        this.inputFluid = ItemStack.f_41583_;
        this.inputFluidAmount = "0";
        this.inputEnergy = "0";
        this.outputStacks = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        this.outputFluid = ItemStack.f_41583_;
        this.outputFluidAmount = "0";
        this.outputEnergy = "0";
    }

    @Override
    public void deactivate() {
    }

    @Override
    public Component validate() {
        if (!this.inputFluid.m_41619_() && Helpers.getFluidStack(this.inputFluid).isEmpty()) {
            return Component.m_237115_((String)"valuetype.integrateddynamics.error.fluid.no_fluid");
        }
        if (!this.outputFluid.m_41619_() && Helpers.getFluidStack(this.outputFluid).isEmpty()) {
            return Component.m_237115_((String)"valuetype.integrateddynamics.error.fluid.no_fluid");
        }
        try {
            Integer.parseInt(this.inputFluidAmount);
        }
        catch (NumberFormatException e) {
            return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{this.inputFluidAmount});
        }
        try {
            Integer.parseInt(this.outputFluidAmount);
        }
        catch (NumberFormatException e) {
            return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{this.outputFluidAmount});
        }
        try {
            Long.parseLong(this.inputEnergy);
        }
        catch (NumberFormatException e) {
            return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{this.inputEnergy});
        }
        try {
            Long.parseLong(this.outputEnergy);
        }
        catch (NumberFormatException e) {
            return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{this.outputEnergy});
        }
        for (ItemMatchProperties inputStack : this.inputStacks) {
            if (inputStack.getItemTag() == null) continue;
            try {
                new ResourceLocation(inputStack.getItemTag());
            }
            catch (ResourceLocationException e) {
                return Component.m_237110_((String)"valuetype.integrateddynamics.error.invalid_input", (Object[])new Object[]{inputStack.getItemTag()});
            }
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean slotClick(int slotId, Slot slot, int mouseButton, ClickType clickType, Player player) {
        if (slotId >= 4 && slotId < 13) {
            int quantityNew;
            if (clickType == ClickType.QUICK_MOVE && mouseButton == 0) {
                if (player.f_19853_.m_5776_()) {
                    int id = slotId - 4;
                    this.lastGui.setPropertySubGui(id);
                }
                return true;
            }
            ItemMatchProperties props = (ItemMatchProperties)this.getInputStacks().get(slotId - 4);
            int quantityCurrent = props.getTagQuantity();
            if (clickType == ClickType.QUICK_MOVE) {
                quantityNew = mouseButton == 0 ? (quantityCurrent + 1) / 2 : quantityCurrent * 2;
            } else {
                int n = quantityNew = mouseButton == 0 ? quantityCurrent - 1 : quantityCurrent + 1;
            }
            if (quantityNew > slot.m_6641_()) {
                quantityNew = slot.m_6641_();
            }
            props.setTagQuantity(quantityNew);
            if (!props.getItemStack().m_41619_()) {
                props.getItemStack().m_41764_(quantityNew);
            }
            if (quantityNew <= 0) {
                props.setItemTag(null);
                props.setTagQuantity(1);
                if (MinecraftHelpers.isClientSideThread()) {
                    this.refreshPropertiesGui(slotId - 4);
                }
            }
        }
        return super.slotClick(slotId, slot, mouseButton, clickType, player);
    }

    @Override
    public Slot createSlot(Container temporaryInputSlots, final int slotId, int x, int y) {
        SlotExtended slot = new SlotExtended(temporaryInputSlots, slotId, x, y){

            public boolean m_5857_(ItemStack itemStack) {
                return ValueTypeRecipeLPElement.this.isItemValidForSlot(slotId, itemStack);
            }

            public ItemStack m_7993_() {
                ItemMatchProperties props;
                String tagName;
                if (MinecraftHelpers.isClientSideThread() && slotId < 9 && (tagName = (props = (ItemMatchProperties)ValueTypeRecipeLPElement.this.getInputStacks().get(slotId)).getItemTag()) != null) {
                    try {
                        ITag tag = ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(tagName)));
                        if (!tag.isEmpty()) {
                            List items = tag.stream().toList();
                            int tick = (int)Minecraft.m_91087_().f_91073_.m_46467_() / 30;
                            Item item = (Item)items.get(tick % items.size());
                            return new ItemStack((ItemLike)item, props.getTagQuantity());
                        }
                    }
                    catch (ResourceLocationException resourceLocationException) {
                        // empty catch block
                    }
                }
                return super.m_7993_();
            }
        };
        slot.setPhantom(true);
        return slot;
    }

    @Override
    public int getItemStackSizeLimit() {
        return 64;
    }

    protected Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getInputs(List<ItemMatchProperties> itemStacks, ItemStack fluid, int fluidAmount, long energy) {
        List energies;
        int lastNonEmpty = 0;
        for (int i = 0; i < itemStacks.size(); ++i) {
            if (!itemStacks.get(i).isValid()) continue;
            lastNonEmpty = i + 1;
        }
        itemStacks = itemStacks.subList(0, lastNonEmpty);
        FluidStack fluidStack = Helpers.getFluidStack(fluid);
        if (!fluidStack.isEmpty()) {
            fluidStack.setAmount(fluidAmount);
        }
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        List items = itemStacks.stream().map(ItemMatchProperties::createPrototypedIngredient).collect(Collectors.toList());
        List fluids = !fluidStack.isEmpty() ? Collections.singletonList(new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.FLUIDSTACK, (Object)fluidStack, (Object)3)))) : Collections.emptyList();
        List<Object> list = energies = energy > 0L ? Collections.singletonList(new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ENERGY, (Object)energy, (Object)false)))) : Collections.emptyList();
        if (!items.isEmpty()) {
            inputs.put(IngredientComponent.ITEMSTACK, items);
        }
        if (!fluids.isEmpty()) {
            inputs.put(IngredientComponent.FLUIDSTACK, fluids);
        }
        if (!energies.isEmpty()) {
            inputs.put(IngredientComponent.ENERGY, energies);
        }
        return inputs;
    }

    protected Map<IngredientComponent<?, ?>, List<Boolean>> getInputsReusable(List<ItemMatchProperties> itemStacks) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        List items = itemStacks.stream().map(ItemMatchProperties::isReusable).collect(Collectors.toList());
        if (!items.isEmpty()) {
            inputs.put(IngredientComponent.ITEMSTACK, items);
        }
        return inputs;
    }

    protected Map<IngredientComponent<?, ?>, List<?>> getOutputs(List<ItemStack> itemStacksIn, ItemStack fluid, int fluidAmount, long energy) {
        ArrayList itemStacks = Lists.newArrayList();
        for (int i = 0; i < itemStacksIn.size(); ++i) {
            if (itemStacksIn.get(i).m_41619_()) continue;
            itemStacks.add(itemStacksIn.get(i));
        }
        FluidStack fluidStack = Helpers.getFluidStack(fluid);
        if (!fluidStack.isEmpty()) {
            fluidStack.setAmount(fluidAmount);
        }
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        if (!itemStacks.isEmpty()) {
            outputs.put(IngredientComponent.ITEMSTACK, itemStacks);
        }
        if (!fluidStack.isEmpty()) {
            outputs.put(IngredientComponent.FLUIDSTACK, Collections.singletonList(fluidStack));
        }
        if (energy > 0L) {
            outputs.put(IngredientComponent.ENERGY, Collections.singletonList(energy));
        }
        return outputs;
    }

    @Override
    public IValue getValue() {
        if (!this.isInputValid() && !this.isOutputValid()) {
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }
        return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition(this.getInputs((List<ItemMatchProperties>)this.inputStacks, this.inputFluid, Integer.parseInt(this.inputFluidAmount), Long.parseLong(this.inputEnergy)), this.getInputsReusable((List<ItemMatchProperties>)this.inputStacks), (IMixedIngredients)new MixedIngredients(this.getOutputs((List<ItemStack>)this.outputStacks, this.outputFluid, Integer.parseInt(this.outputFluidAmount), Long.parseLong(this.outputEnergy)))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.lastGui = new ValueTypeRecipeLPElementMasterSubGui(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.lastGui;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setValueInGui(ISubGuiBox subGui) {
        int i;
        ValueTypeRecipeLPElementRecipeSubGui gui = ((ValueTypeRecipeLPElementMasterSubGui)subGui).getSubGuiRecipe();
        Container slots = ((ContainerLogicProgrammerBase)gui.container).getTemporaryInputSlots();
        for (i = 0; i < this.inputStacks.size(); ++i) {
            ItemMatchProperties entry = (ItemMatchProperties)this.inputStacks.get(i);
            slots.m_6836_(i, entry.getItemStack());
        }
        slots.m_6836_(9, this.inputFluid);
        if (gui.getInputFluidAmountBox() != null) {
            gui.getInputFluidAmountBox().m_94144_(this.inputFluidAmount);
            gui.getInputEnergyBox().m_94144_(this.inputEnergy);
            for (i = 0; i < this.outputStacks.size(); ++i) {
                slots.m_6836_(10 + i, (ItemStack)this.outputStacks.get(i));
            }
            slots.m_6836_(13, this.outputFluid);
            gui.getOutputFluidAmountBox().m_94144_(this.outputFluidAmount);
            gui.getOutputEnergyBox().m_94144_(this.outputEnergy);
        }
    }

    public NonNullList<ItemMatchProperties> getInputStacks() {
        return this.inputStacks;
    }

    public String getInputFluidAmount() {
        return this.inputFluidAmount;
    }

    public void setInputFluidAmount(String inputFluidAmount) {
        this.inputFluidAmount = inputFluidAmount;
    }

    public String getInputEnergy() {
        return this.inputEnergy;
    }

    public void setInputEnergy(String inputEnergy) {
        this.inputEnergy = inputEnergy;
    }

    public String getOutputFluidAmount() {
        return this.outputFluidAmount;
    }

    public void setOutputFluidAmount(String outputFluidAmount) {
        this.outputFluidAmount = outputFluidAmount;
    }

    public String getOutputEnergy() {
        return this.outputEnergy;
    }

    public void setOutputEnergy(String outputEnergy) {
        this.outputEnergy = outputEnergy;
    }
}

