/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeBooleanLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueTypeBoolean
extends ValueTypeBase<ValueBoolean> {
    public ValueTypeBoolean() {
        super("boolean", Helpers.RGBToInt((int)43, (int)47, (int)231), ChatFormatting.BLUE, ValueBoolean.class);
    }

    @Override
    public ValueBoolean getDefault() {
        return ValueBoolean.of(false);
    }

    @Override
    public MutableComponent toCompactString(ValueBoolean value) {
        return Component.m_237113_((String)Boolean.toString(value.getRawValue()));
    }

    @Override
    public Tag serialize(ValueBoolean value) {
        return ByteTag.m_128266_((byte)(value.getRawValue() ? (byte)1 : 0));
    }

    @Override
    public ValueBoolean deserialize(Tag value) {
        if (value.m_7060_() == 1) {
            return ValueBoolean.of(((ByteTag)value).m_7063_() == 1);
        }
        throw new IllegalArgumentException(String.format("Value \"%s\" could not be parsed to a boolean.", value));
    }

    @Override
    public String toString(ValueBoolean value) {
        return Boolean.toString(value.getRawValue());
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeBooleanLPElement((IValueType)this);
    }

    @Override
    public ValueBoolean parseString(String value) throws EvaluationException {
        boolean b;
        if ("true".equalsIgnoreCase(value) || "1".equals(value)) {
            b = true;
        } else if ("false".equalsIgnoreCase(value) || "0".equals(value)) {
            b = false;
        } else {
            throw new EvaluationException(Component.m_237110_((String)"operator.integrateddynamics.error.parse", (Object[])new Object[]{value, Component.m_237115_((String)this.getTranslationKey())}));
        }
        return ValueBoolean.of(b);
    }

    public static class ValueBoolean
    extends ValueBase {
        private static final ValueBoolean TRUE = new ValueBoolean(true);
        private static final ValueBoolean FALSE = new ValueBoolean(false);
        private final boolean value;

        private ValueBoolean(boolean value) {
            super(ValueTypes.BOOLEAN);
            this.value = value;
        }

        public static ValueBoolean of(boolean value) {
            return value ? TRUE : FALSE;
        }

        public boolean getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueBoolean && ((ValueBoolean)o).value == this.value;
        }

        public int hashCode() {
            return this.getType().hashCode() + (this.value ? 1 : 0);
        }

        @Override
        public String toString() {
            return "ValueTypeBoolean.ValueBoolean(value=" + this.value + ")";
        }
    }
}

